/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.AttributeSelectionSchema;

class MultipleCandidateMatcher<T extends HasAttributes> {
    private final AttributeSelectionSchema schema;
    private final ImmutableAttributes requested;
    private final List<? extends T> candidates;
    private final ImmutableAttributes[] candidateAttributeSets;
    private final List<Attribute<?>> requestedAttributes;
    private final BitSet compatible;
    private final Object[] requestedAttributeValues;
    private int candidateWithLongestMatch;
    private int lengthOfLongestMatch;
    private BitSet remaining;
    private Attribute<?>[] extraAttributes;

    MultipleCandidateMatcher(AttributeSelectionSchema schema, Collection<? extends T> candidates, ImmutableAttributes requested) {
        this.schema = schema;
        this.requested = requested;
        this.candidates = candidates instanceof List ? (List)candidates : ImmutableList.copyOf(candidates);
        this.candidateAttributeSets = new ImmutableAttributes[candidates.size()];
        for (int i = 0; i < candidates.size(); ++i) {
            this.candidateAttributeSets[i] = ((AttributeContainerInternal)((HasAttributes)this.candidates.get(i)).getAttributes()).asImmutable();
        }
        this.requestedAttributes = requested.keySet().asList();
        this.requestedAttributeValues = new Object[(1 + candidates.size()) * this.requestedAttributes.size()];
        this.compatible = new BitSet(candidates.size());
        this.compatible.set(0, candidates.size());
    }

    public List<T> getMatches() {
        this.fillRequestedValues();
        this.findCompatibleCandidates();
        if (this.compatible.cardinality() <= 1) {
            return this.getCandidates(this.compatible);
        }
        if (this.longestMatchIsSuperSetOfAllOthers()) {
            return Collections.singletonList(this.candidates.get(this.candidateWithLongestMatch));
        }
        return this.disambiguateCompatibleCandidates();
    }

    private void fillRequestedValues() {
        for (int a = 0; a < this.requestedAttributes.size(); ++a) {
            Attribute<?> attribute = this.requestedAttributes.get(a);
            AttributeValue attributeValue = this.requested.findEntry(attribute);
            this.setRequestedValue(a, attributeValue.isPresent() ? attributeValue.get() : null);
        }
    }

    private void findCompatibleCandidates() {
        for (int c = 0; c < this.candidates.size(); ++c) {
            this.matchCandidate(c);
        }
    }

    private void matchCandidate(int c) {
        int matchLength = 0;
        for (int a = 0; a < this.requestedAttributes.size(); ++a) {
            MatchResult result = this.recordAndMatchCandidateValue(c, a);
            if (result == MatchResult.NO_MATCH) {
                this.compatible.clear(c);
                return;
            }
            if (result != MatchResult.MATCH) continue;
            ++matchLength;
        }
        if (matchLength > this.lengthOfLongestMatch) {
            this.lengthOfLongestMatch = matchLength;
            this.candidateWithLongestMatch = c;
        }
    }

    private MatchResult recordAndMatchCandidateValue(int c, int a) {
        Object requestedValue = this.getRequestedValue(a);
        Attribute<?> attribute = this.requestedAttributes.get(a);
        AttributeValue candidateValue = this.candidateAttributeSets[c].findEntry(attribute.getName());
        if (!candidateValue.isPresent()) {
            this.setCandidateValue(c, a, null);
            return MatchResult.MISSING;
        }
        Object coercedValue = candidateValue.coerce(attribute);
        this.setCandidateValue(c, a, coercedValue);
        return this.schema.matchValue(attribute, requestedValue, coercedValue) ? MatchResult.MATCH : MatchResult.NO_MATCH;
    }

    private boolean longestMatchIsSuperSetOfAllOthers() {
        int c = this.compatible.nextSetBit(0);
        while (c >= 0) {
            if (c != this.candidateWithLongestMatch) {
                int lengthOfOtherMatch = 0;
                for (int a = 0; a < this.requestedAttributes.size(); ++a) {
                    if (this.getCandidateValue(c, a) == null) continue;
                    ++lengthOfOtherMatch;
                    if (this.getCandidateValue(this.candidateWithLongestMatch, a) != null) continue;
                    return false;
                }
                if (lengthOfOtherMatch == this.lengthOfLongestMatch) {
                    return false;
                }
            }
            c = this.compatible.nextSetBit(c + 1);
        }
        return true;
    }

    private List<T> disambiguateCompatibleCandidates() {
        this.remaining = new BitSet(this.candidates.size());
        this.remaining.or(this.compatible);
        this.disambiguateWithRequestedAttributes();
        if (this.remaining.cardinality() > 1) {
            this.disambiguateWithExtraAttributes();
        }
        return this.remaining.cardinality() == 0 ? this.getCandidates(this.compatible) : this.getCandidates(this.remaining);
    }

    private void disambiguateWithRequestedAttributes() {
        for (int a = 0; a < this.requestedAttributes.size(); ++a) {
            this.disambiguateWithAttribute(a);
            if (this.remaining.cardinality() != 0) continue;
            return;
        }
    }

    private void disambiguateWithAttribute(int a) {
        Set<Object> candidateValues = this.getCandidateValues(a);
        if (candidateValues.size() <= 1) {
            return;
        }
        Set<Object> matches = this.schema.disambiguate(this.getAttribute(a), this.getRequestedValue(a), candidateValues);
        if (matches.size() < candidateValues.size()) {
            this.removeCandidatesWithValueNotIn(a, matches);
        }
    }

    private Set<Object> getCandidateValues(int a) {
        HashSet candidateValues = Sets.newHashSetWithExpectedSize((int)this.compatible.cardinality());
        int c = this.compatible.nextSetBit(0);
        while (c >= 0) {
            Object candidateValue = this.getCandidateValue(c, a);
            if (candidateValue != null) {
                candidateValues.add(candidateValue);
            }
            c = this.compatible.nextSetBit(c + 1);
        }
        return candidateValues;
    }

    private void removeCandidatesWithValueNotIn(int a, Set<Object> matchedValues) {
        int c = this.remaining.nextSetBit(0);
        while (c >= 0) {
            if (!matchedValues.contains(this.getCandidateValue(c, a))) {
                this.remaining.clear(c);
            }
            c = this.remaining.nextSetBit(c + 1);
        }
    }

    private void disambiguateWithExtraAttributes() {
        this.collectExtraAttributes();
        int allAttributes = this.requestedAttributes.size() + this.extraAttributes.length;
        for (int a = this.requestedAttributes.size(); a < allAttributes; ++a) {
            this.disambiguateWithAttribute(a);
            if (this.remaining.cardinality() != 0) continue;
            return;
        }
    }

    private void collectExtraAttributes() {
        this.extraAttributes = this.schema.collectExtraAttributes(this.candidateAttributeSets, this.requested);
    }

    private List<T> getCandidates(BitSet liveSet) {
        if (liveSet.cardinality() == 0) {
            return Collections.emptyList();
        }
        if (liveSet.cardinality() == 1) {
            return Collections.singletonList(this.candidates.get(liveSet.nextSetBit(0)));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int c = liveSet.nextSetBit(0);
        while (c >= 0) {
            builder.add(this.candidates.get(c));
            c = liveSet.nextSetBit(c + 1);
        }
        return builder.build();
    }

    private Attribute<?> getAttribute(int a) {
        if (a < this.requestedAttributes.size()) {
            return this.requestedAttributes.get(a);
        }
        return this.extraAttributes[a - this.requestedAttributes.size()];
    }

    private Object getRequestedValue(int a) {
        if (a < this.requestedAttributes.size()) {
            return this.requestedAttributeValues[a];
        }
        return null;
    }

    private Object getCandidateValue(int c, int a) {
        if (a < this.requestedAttributes.size()) {
            return this.requestedAttributeValues[this.getValueIndex(c, a)];
        }
        Attribute<?> extraAttribute = this.getAttribute(a);
        AttributeValue attributeValue = this.candidateAttributeSets[c].findEntry(extraAttribute.getName());
        return attributeValue.isPresent() ? attributeValue.coerce(extraAttribute) : null;
    }

    private void setRequestedValue(int a, Object value) {
        this.requestedAttributeValues[a] = value;
    }

    private void setCandidateValue(int c, int a, Object value) {
        this.requestedAttributeValues[this.getValueIndex((int)c, (int)a)] = value;
    }

    private int getValueIndex(int c, int a) {
        return (1 + c) * this.requestedAttributes.size() + a;
    }

    private static enum MatchResult {
        MATCH,
        MISSING,
        NO_MATCH;

    }
}

