/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public final class PropertyConverter {
    public static Boolean toBoolean(Object value) throws ConversionException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean b = BooleanUtils.toBooleanObject((String)((String)value));
            if (b == null) {
                throw new ConversionException("The value " + value + " can't be converted to a Boolean object");
            }
            return b;
        }
        throw new ConversionException("The value " + value + " can't be converted to a Boolean object");
    }

    public static Byte toByte(Object value) throws ConversionException {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            try {
                String string = (String)value;
                if (string.startsWith("0x")) {
                    return new Byte((byte)Integer.parseInt(string.substring(2), 16));
                }
                return new Byte(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Byte object", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Byte object");
    }

    public static Short toShort(Object value) throws ConversionException {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            try {
                String string = (String)value;
                if (string.startsWith("0x")) {
                    return new Short((short)Integer.parseInt(string.substring(2), 16));
                }
                return new Short(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Short object", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Short object");
    }

    public static Integer toInteger(Object value) throws ConversionException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                String string = (String)value;
                if (string.startsWith("0x")) {
                    return new Integer((int)Long.parseLong(string.substring(2), 16));
                }
                return new Integer(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("The value " + value + " can't be converted to an Integer object", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to an Integer object");
    }

    public static Long toLong(Object value) throws ConversionException {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                String string = (String)value;
                if (string.startsWith("0x")) {
                    return new Long(new BigInteger(string.substring(2), 16).longValue());
                }
                return new Long(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Long object", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Long object");
    }

    public static Float toFloat(Object value) throws ConversionException {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            try {
                return new Float((String)value);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Float object", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Float object");
    }

    public static Double toDouble(Object value) throws ConversionException {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            try {
                return new Double((String)value);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Double object", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Double object");
    }

    public static BigInteger toBigInteger(Object value) throws ConversionException {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof String) {
            try {
                String string = (String)value;
                if (string.startsWith("0x")) {
                    return new BigInteger(string.substring(2), 16);
                }
                return new BigInteger(string);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("The value " + value + " can't be converted to a BigInteger object", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a BigInteger object");
    }

    public static BigDecimal toBigDecimal(Object value) throws ConversionException {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("The value " + value + " can't be converted to a BigDecimal object", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a BigDecimal object");
    }

    public static URL toURL(Object value) throws ConversionException {
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof String) {
            try {
                return new URL((String)value);
            }
            catch (MalformedURLException e) {
                throw new ConversionException("The value " + value + " can't be converted to an URL", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to an URL");
    }

    public static Locale toLocale(Object value) throws ConversionException {
        if (value instanceof Locale) {
            return (Locale)value;
        }
        if (value instanceof String) {
            List elements = PropertyConverter.split((String)value, '_');
            int size = elements.size();
            if (size >= 1 && (((String)elements.get(0)).length() == 2 || ((String)elements.get(0)).length() == 0)) {
                String language = (String)elements.get(0);
                String country = size >= 2 ? elements.get(1) : "";
                String variant = size >= 3 ? elements.get(2) : "";
                return new Locale(language, country, variant);
            }
            throw new ConversionException("The value " + value + " can't be converted to a Locale");
        }
        throw new ConversionException("The value " + value + " can't be converted to a Locale");
    }

    public static List split(String s, char delimiter) {
        if (s == null) {
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer token = new StringBuffer();
        int begin = 0;
        int end = 0;
        while (begin <= s.length()) {
            int index = s.indexOf(delimiter, end);
            String chunk = s.substring(begin, end = index != -1 ? index : s.length());
            if (chunk.endsWith("\\") && end != s.length()) {
                token.append(chunk.substring(0, chunk.length() - 1));
                token.append(delimiter);
            } else {
                token.append(chunk);
                list.add(token.toString().trim());
                token = new StringBuffer();
            }
            begin = ++end;
        }
        return list;
    }

    public static Color toColor(Object value) throws ConversionException {
        if (value instanceof Color) {
            return (Color)value;
        }
        if (value instanceof String && !StringUtils.isBlank((String)((String)value)) && ((String)value).length() >= 6) {
            try {
                String color = ((String)value).trim();
                if (color.startsWith("#")) {
                    color = color.substring(1);
                }
                int red = Integer.parseInt(color.substring(0, 2), 16);
                int green = Integer.parseInt(color.substring(2, 4), 16);
                int blue = Integer.parseInt(color.substring(4, 6), 16);
                int alpha = 255;
                if (color.length() >= 8) {
                    alpha = Integer.parseInt(color.substring(6, 8), 16);
                }
                return new Color(red, green, blue, alpha);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value + " can't be converted to a Color", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Color");
    }

    public static Date toDate(Object value, String format) throws ConversionException {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof String) {
            try {
                return new SimpleDateFormat(format).parse((String)value);
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Date", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Date");
    }

    public static Calendar toCalendar(Object value, String format) throws ConversionException {
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            return calendar;
        }
        if (value instanceof String) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new SimpleDateFormat(format).parse((String)value));
                return calendar;
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Calendar", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Calendar");
    }

    public static Iterator toIterator(Object value, char delimiter) {
        if (value == null) {
            return IteratorUtils.emptyIterator();
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.indexOf(delimiter) > 0) {
                return PropertyConverter.split((String)value, delimiter).iterator();
            }
            return new SingletonIterator(value);
        }
        if (value instanceof Collection) {
            return PropertyConverter.toIterator(((Collection)value).iterator(), delimiter);
        }
        if (value.getClass().isArray()) {
            return PropertyConverter.toIterator(IteratorUtils.arrayIterator((Object)value), delimiter);
        }
        if (value instanceof Iterator) {
            Iterator iterator = (Iterator)value;
            IteratorChain chain = new IteratorChain();
            while (iterator.hasNext()) {
                chain.addIterator(PropertyConverter.toIterator(iterator.next(), delimiter));
            }
            return chain;
        }
        return new SingletonIterator(value);
    }
}

