/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.TransformGroup;
import megamek.client.ui.AWT.boardview3d.BoardModel;

abstract class HexModel
extends TransformGroup {
    private static final double[] hexVertices = new double[]{-BoardModel.HEX_SIDE_LENGTH / 2.0, 15.0, 0.0, -BoardModel.HEX_SIDE_LENGTH, 0.0, 0.0, -BoardModel.HEX_SIDE_LENGTH / 2.0, -15.0, 0.0, BoardModel.HEX_SIDE_LENGTH / 2.0, -15.0, 0.0, BoardModel.HEX_SIDE_LENGTH, 0.0, 0.0, BoardModel.HEX_SIDE_LENGTH / 2.0, 15.0, 0.0, -BoardModel.HEX_SIDE_LENGTH / 2.0, 15.0, 0.0};
    static final GeometryArray polygon = HexModel.makeHex();
    static final GeometryArray border = HexModel.makeHexOutline();
    static final GeometryArray shaft = HexModel.makeHexShaft();

    HexModel() {
    }

    private static final GeometryArray makeHex() {
        GeometryInfo geometryInfo = new GeometryInfo(5);
        float[] fArray = new float[]{0.25f, 1.0f, 0.0f, 0.5f, 0.25f, 0.0f, 0.75f, 0.0f, 1.0f, 0.5f, 0.75f, 1.0f, 0.25f, 1.0f};
        float[] fArray2 = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        geometryInfo.setCoordinates(hexVertices);
        geometryInfo.setStripCounts(new int[]{hexVertices.length / 3});
        geometryInfo.setContourCounts(new int[]{1});
        geometryInfo.setNormals(fArray2);
        geometryInfo.setTextureCoordinateParams(1, 2);
        geometryInfo.setTextureCoordinates(0, fArray);
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        return geometryInfo.getGeometryArray();
    }

    private static final GeometryArray makeHexShaft() {
        GeometryInfo geometryInfo = new GeometryInfo(4);
        double[] dArray = new double[hexVertices.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = hexVertices[n];
            dArray[n2 + 1] = hexVertices[n + 1];
            dArray[n2 + 2] = -0.001;
            dArray[n2 + 3] = hexVertices[n];
            dArray[n2 + 4] = hexVertices[n + 1];
            dArray[n2 + 5] = -120.0;
            n2 += 6;
            n += 3;
        }
        geometryInfo.setCoordinates(dArray);
        geometryInfo.setStripCounts(new int[]{dArray.length / 3});
        NormalGenerator normalGenerator = new NormalGenerator(0.0);
        normalGenerator.generateNormals(geometryInfo);
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        return geometryInfo.getGeometryArray();
    }

    private static final GeometryArray makeHexOutline() {
        LineStripArray lineStripArray = new LineStripArray(hexVertices.length, 1, new int[]{hexVertices.length / 3});
        lineStripArray.setCoordinates(0, hexVertices);
        return lineStripArray;
    }
}

