/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.RangeType;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MissileWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATMHandler
extends MissileWeaponHandler {
    private static final long serialVersionUID = -2536312899803153911L;

    public ATMHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcDamagePerHit() {
        double d;
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        if (ammoType.getMunitionType() == 256L) {
            this.sSalvoType = " high-explosive missile(s) ";
            d = 3.0;
        } else if (ammoType.getMunitionType() == 128L) {
            this.sSalvoType = " extended-range missile(s) ";
            d = 1.0;
        } else {
            d = 2.0;
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            d = Compute.directBlowInfantryDamage((double)this.wtype.getRackSize() * d, this.bDirect ? this.toHit.getMoS() / 3 : 0, 3, ((Infantry)this.target).isMechanized());
            if (this.bGlancing) {
                d /= 2.0;
            }
        }
        return (int)d;
    }

    @Override
    protected int calcnCluster() {
        return 5;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        int n = ammoType.getMunitionType() == 256L ? super.calcHits(vector) : this.calcStandardAndExtendedAmmoHits(vector);
        n = this.nDamPerHit * n;
        this.nDamPerHit = 1;
        return n;
    }

    @Override
    protected int calcAttackValue() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        int n2 = 0;
        int n3 = RangeType.rangeBracket(n, this.wtype.getATRanges(), true);
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        if (ammoType.getMunitionType() == 256L) {
            if (n3 == 1) {
                n2 = this.wtype.getRoundShortAV();
                n2 += n2 / 2;
            }
        } else if (ammoType.getMunitionType() == 128L) {
            if (n3 == 1) {
                n2 = this.wtype.getRoundShortAV();
            } else if (n3 == 2) {
                n2 = this.wtype.getRoundMedAV();
            } else if (n3 == 3) {
                n2 = this.wtype.getRoundLongAV();
            } else if (n3 == 4) {
                n2 = this.wtype.getRoundLongAV();
            }
            n2 /= 2;
        } else if (n3 == 1) {
            n2 = this.wtype.getRoundShortAV();
        } else if (n3 == 2) {
            n2 = this.wtype.getRoundMedAV();
        } else if (n3 == 3) {
            n2 = this.wtype.getRoundLongAV();
        } else if (n3 == 4) {
            n2 = this.wtype.getRoundExtAV();
        }
        return n2;
    }

    protected int calcStandardAndExtendedAmmoHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                this.r = new Report(3325);
                this.r.subject = this.subjectId;
                this.r.add(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength());
                this.r.add(this.sSalvoType);
                this.r.add(this.toHit.getTableDesc());
                this.r.newlines = 0;
                vector.add(this.r);
                return ((BattleArmor)this.ae).getShootingStrength();
            }
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(this.wtype.getRackSize());
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.add(this.r);
            return 1;
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        int n2 = this.nSalvoBonus;
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
            n2 -= 2;
        }
        boolean bl = false;
        if (this.ae instanceof Mech) {
            bl = this.ae.isStealthActive();
        }
        Mounted mounted = this.weapon.getLinkedBy();
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        boolean bl2 = false;
        if (Compute.isAffectedByECM(this.ae, this.ae.getPosition(), this.target.getPosition())) {
            bl2 = true;
        }
        if (mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L) && ammoType.getMunitionType() == 8192L) {
            if (bl2) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (ammoType.getAmmoType() == 28) {
            if (bl2) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (entity != null && (entity.isNarcedBy(this.ae.getOwner().getTeam()) || entity.isINarcedBy(this.ae.getOwner().getTeam()))) {
            boolean bl3 = false;
            bl3 = Compute.isAffectedByECM(this.ae, this.target.getPosition(), this.target.getPosition());
            if (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45 && ammoType.getMunitionType() == 4096L && (this.weapon.curMode() == null || !this.weapon.curMode().equals("Indirect"))) {
                if (bl3) {
                    this.r = new Report(3330);
                    this.r.subject = this.subjectId;
                    this.r.newlines = 0;
                    vector.addElement(this.r);
                } else {
                    n2 += 2;
                }
            }
        }
        if (this.bGlancing) {
            n2 -= 4;
        }
        if (this.bDirect) {
            n2 += this.toHit.getMoS() / 3 * 2;
        }
        if (this.game.getPlanetaryConditions().hasEMI()) {
            n2 -= 2;
        }
        if ((n = this.allShotsHit() ? this.wtype.getRackSize() : (this.ae instanceof BattleArmor ? Compute.missilesHit(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength(), n2, this.weapon.isHotLoaded()) : Compute.missilesHit(this.wtype.getRackSize(), n2 += this.getAMSHitsMod(vector), this.weapon.isHotLoaded()))) > 0) {
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.addElement(this.r);
            if (n2 != 0) {
                this.r = n2 > 0 ? new Report(3340) : new Report(3341);
                this.r.subject = this.subjectId;
                this.r.add(n2);
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
        }
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }

    @Override
    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        if (!bl && this.target.getTargetType() == 5) {
            this.r = new Report(3255);
            this.r.indent(1);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
            Coords coords = this.target.getPosition();
            Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (enumeration.hasMoreElements()) {
                Minefield minefield = enumeration.nextElement();
                if (!this.server.clearMinefield(minefield, this.ae, 5, vector)) continue;
                arrayList.add(minefield);
            }
            for (Minefield minefield : arrayList) {
                this.server.removeMinefield(minefield);
            }
            return true;
        }
        return false;
    }
}

