/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.io.File;
import java.io.IOException;
import megamek.common.Compute;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.AbstractCommandLineParser;
import megamek.server.Server;

public class DedicatedServer {
    private static final String INCORRECT_ARGUMENTS_MESSAGE = "Incorrect arguments:";
    private static final String ARGUMENTS_DESCRIPTION_MESSAGE = "Arguments syntax:\n\t [-port <port>] [<saved game>]";

    public static void start(String[] stringArray) {
        CommandLineParser commandLineParser = new CommandLineParser(stringArray);
        try {
            Server server;
            commandLineParser.parse();
            String string = commandLineParser.getGameFilename();
            int n = commandLineParser.getPort() != -1 ? commandLineParser.getPort() : PreferenceManager.getClientPreferences().getLastServerPort();
            Compute.d6();
            try {
                server = new Server(PreferenceManager.getClientPreferences().getLastServerPass(), n);
            }
            catch (IOException iOException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Error: could not start server at localhost").append(":").append(n).append(" (").append(iOException.getMessage()).append(").");
                System.err.println(stringBuffer.toString());
                return;
            }
            if (null != string) {
                server.loadGame(new File(string));
            }
            return;
        }
        catch (AbstractCommandLineParser.ParseException parseException) {
            StringBuffer stringBuffer = new StringBuffer(INCORRECT_ARGUMENTS_MESSAGE).append(parseException.getMessage()).append('\n');
            stringBuffer.append(ARGUMENTS_DESCRIPTION_MESSAGE);
            DedicatedServer.displayMessage(stringBuffer.toString());
            return;
        }
    }

    public static void main(String[] stringArray) {
        DedicatedServer.start(stringArray);
    }

    private static void displayMessage(String string) {
        System.out.println(string);
        System.out.flush();
    }

    private static class CommandLineParser
    extends AbstractCommandLineParser {
        private String gameFilename;
        private int port;
        private static final String OPTION_PORT = "port";

        public CommandLineParser(String[] stringArray) {
            super(stringArray);
        }

        public int getPort() {
            return this.port;
        }

        public String getGameFilename() {
            return this.gameFilename;
        }

        protected void start() throws AbstractCommandLineParser.ParseException {
            if (this.getToken() == 0 && this.getTokenValue().equals(OPTION_PORT)) {
                this.nextToken();
                this.parsePort();
            }
            if (this.getToken() == 3) {
                this.gameFilename = this.getTokenValue();
                this.nextToken();
            }
            if (this.getToken() != -1) {
                this.error("unexpected input");
            }
        }

        private void parsePort() throws AbstractCommandLineParser.ParseException {
            if (this.getToken() == 3) {
                int n = -1;
                try {
                    n = Integer.decode(this.getTokenValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.nextToken();
                if (n < 0 || n > 65535) {
                    this.error("invalid port number");
                }
                this.port = n;
            } else {
                this.error("port number expected");
            }
        }
    }
}

