/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.util.Iterator;
import java.util.Vector;
import megamek.common.Coords;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Report;
import megamek.common.Terrains;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.Server;
import megamek.server.SmokeCloud;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmokeProcessor
extends DynamicTerrainProcessor {
    private IGame game;
    Vector<Report> vPhaseReport;

    public SmokeProcessor(Server server) {
        super(server);
    }

    @Override
    void doEndPhaseChanges(Vector<Report> vector) {
        this.game = this.server.getGame();
        if (this.game.getOptions().booleanOption("tacops_start_fire")) {
            this.vPhaseReport = vector;
            this.resolveSmoke();
            this.vPhaseReport = null;
        }
    }

    private void resolveSmoke() {
        this.updateSmoke();
        this.removeEmptyClouds();
    }

    public void removeEmptyClouds() {
        Iterator<SmokeCloud> iterator = this.server.getSmokeCloudList().iterator();
        while (iterator.hasNext()) {
            SmokeCloud smokeCloud = iterator.next();
            if (smokeCloud.getCoordsList().size() < 1) {
                iterator.remove();
                continue;
            }
            if (smokeCloud.getSmokeLevel() >= 1) continue;
            this.server.removeSmokeTerrain(smokeCloud);
            iterator.remove();
        }
    }

    public void createSmokeTerrain(SmokeCloud smokeCloud) {
        for (Coords coords : smokeCloud.getCoordsList()) {
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex == null) continue;
            if (iHex.containsTerrain(20)) {
                if (iHex.terrainLevel(20) != 1) continue;
                iHex.removeTerrain(20);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(20, 2));
                this.server.sendChangedHex(coords);
                continue;
            }
            if (smokeCloud.getSmokeLevel() <= 0) continue;
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(20, smokeCloud.getSmokeLevel()));
            this.server.sendChangedHex(coords);
        }
    }

    public void updateSmoke() {
        for (SmokeCloud smokeCloud : this.server.getSmokeCloudList()) {
            this.server.removeSmokeTerrain(smokeCloud);
        }
        this.removeEmptyClouds();
        for (SmokeCloud smokeCloud : this.server.getSmokeCloudList()) {
            if (smokeCloud.getCoordsList().size() <= 0 || smokeCloud.getSmokeLevel() <= 0) continue;
            this.createSmokeTerrain(smokeCloud);
        }
    }
}

