/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.util;

import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.OutputListener;
import com.declarativa.interprolog.util.RecognizerListener;
import java.util.Vector;

public class Recognizer
implements OutputListener {
    Vector listeners = new Vector();
    int nextInPattern;
    byte[] bytePattern;
    boolean collectRestOfBuffer;
    byte[] lastBuffer;
    int lastNbytes;

    public Recognizer() {
        this(null);
    }

    public Recognizer(String string) {
        this(string, false);
    }

    public Recognizer(String string, boolean bl) {
        this.bytePattern = string == null ? new byte[0] : string.getBytes();
        this.nextInPattern = 0;
        this.collectRestOfBuffer = bl;
    }

    public int numberListeners() {
        return this.listeners.size();
    }

    public void analyseBytes(byte[] byArray, int n) {
        this.lastBuffer = byArray;
        this.lastNbytes = n;
        if (this.bytePattern.length == 0) {
            this.fireRecognized(new String(byArray, 0, n));
        } else {
            int n2 = 0;
            while (n2 < n) {
                if (byArray[n2] == this.bytePattern[this.nextInPattern]) {
                    ++this.nextInPattern;
                    if (this.nextInPattern >= this.bytePattern.length) {
                        this.nextInPattern = 0;
                        if (this.collectRestOfBuffer && n2 + 1 < n) {
                            this.fireRecognized(new String(byArray, n2 + 1, n - (n2 + 1)));
                            break;
                        }
                        this.fireRecognized("");
                    }
                } else {
                    this.nextInPattern = 0;
                }
                ++n2;
            }
        }
    }

    public void streamEnded() {
        throw new IPException("Unexpected end of stream, Prolog may have died abruptly");
    }

    public synchronized void addRecognizerListener(RecognizerListener recognizerListener) {
        this.listeners.addElement(recognizerListener);
    }

    public synchronized void removeRecognizerListener(RecognizerListener recognizerListener) {
        this.listeners.removeElement(recognizerListener);
    }

    void fireRecognized(String string) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((RecognizerListener)this.listeners.elementAt(n)).recognized(this, string);
            ++n;
        }
    }

    public String toString() {
        return "Recognizer of " + new String(this.bytePattern);
    }
}

