/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.util;

import org.rundeck.client.util.ConfigSource;
import org.rundeck.client.util.ConfigValues;

public class ConfigBase
implements ConfigSource {
    final ConfigValues configSource;

    public ConfigBase(ConfigValues configSource) {
        this.configSource = configSource;
    }

    @Override
    public String get(String key) {
        return this.configSource.get(key);
    }

    @Override
    public String getString(String key, String defval) {
        String val = this.get(key);
        return null == val ? defval : val;
    }

    @Override
    public int getInt(String debug, int defval) {
        String envProp = this.getString(debug, null);
        if (null != envProp) {
            return Integer.parseInt(envProp);
        }
        return defval;
    }

    @Override
    public Long getLong(String key, Long defval) {
        String timeoutEnv = this.getString(key, null);
        if (null != timeoutEnv) {
            return Long.parseLong(timeoutEnv);
        }
        return defval;
    }

    @Override
    public boolean getBool(String key, boolean defval) {
        return "true".equalsIgnoreCase(this.getString(key, defval ? "true" : "false"));
    }

    @Override
    public String require(String name, String description) throws ConfigSource.ConfigSourceError {
        String value = this.get(name);
        if (null == value) {
            throw new ConfigSource.ConfigSourceError(String.format("Environment variable %s is required: %s", name, description));
        }
        return value;
    }
}

