/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTConditionalExpression;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.CollectionUtil;

public class UselessOperationOnImmutable
extends AbstractRule {
    private static final Set<String> targetMethods = CollectionUtil.asSet(new String[]{".add", ".multiply", ".divide", ".subtract", ".setScale", ".negate", ".movePointLeft", ".movePointRight", ".pow", ".shiftLeft", ".shiftRight"});
    private static final Set<String> targetClasses = CollectionUtil.asSet(new String[]{"java.math.BigDecimal", "BigDecimal", "java.math.BigInteger", "BigInteger"});

    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        ASTVariableDeclaratorId var = this.getDeclaration(node);
        if (var == null) {
            return super.visit(node, data);
        }
        String variableName = var.getImage();
        for (NameOccurrence no : var.getUsages()) {
            String methodCall;
            SimpleNode sn = no.getLocation();
            Class<?> parentClass = sn.jjtGetParent().jjtGetParent().jjtGetParent().getClass();
            if (parentClass.equals(ASTExpression.class) || parentClass.equals(ASTConditionalExpression.class) || !targetMethods.contains(methodCall = sn.getImage().substring(variableName.length()))) continue;
            this.addViolation(data, sn);
        }
        return super.visit(node, data);
    }

    private ASTVariableDeclaratorId getDeclaration(ASTLocalVariableDeclaration node) {
        ASTType type = node.getTypeNode();
        if (targetClasses.contains(type.getTypeImage())) {
            return (ASTVariableDeclaratorId)node.jjtGetChild(1).jjtGetChild(0);
        }
        return null;
    }
}

