/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.migration;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.ast.ASTAnnotation;
import net.sourceforge.pmd.ast.ASTBlock;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTCatchStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTThrowStatement;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.junit.AbstractJUnitRule;

public class JUnitUseExpected
extends AbstractJUnitRule {
    public Object visit(ASTClassOrInterfaceBodyDeclaration node, Object data) {
        boolean inAnnotation = false;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASTName annotationName;
            Node child = node.jjtGetChild(i);
            if (ASTAnnotation.class.equals(child.getClass()) && "Test".equals((annotationName = ((SimpleNode)child).getFirstChildOfType(ASTName.class)).getImage())) {
                inAnnotation = true;
                continue;
            }
            if (ASTMethodDeclaration.class.equals(child.getClass())) {
                boolean isJUnitMethod = this.isJUnitMethod((ASTMethodDeclaration)child, data);
                if (inAnnotation || isJUnitMethod) {
                    ArrayList found = new ArrayList();
                    found.addAll((List)this.visit((ASTMethodDeclaration)child, data));
                    for (SimpleNode name : found) {
                        this.addViolation(data, name);
                    }
                }
            }
            inAnnotation = false;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        List<ASTTryStatement> catches = node.findChildrenOfType(ASTTryStatement.class);
        ArrayList<SimpleJavaNode> found = new ArrayList<SimpleJavaNode>();
        if (catches.isEmpty()) {
            return found;
        }
        for (ASTTryStatement trySt : catches) {
            List<ASTBlockStatement> blocks;
            ASTBlock block;
            ASTCatchStatement cStatement = this.getCatch(trySt);
            if (cStatement == null || (block = (ASTBlock)cStatement.jjtGetChild(1)).jjtGetNumChildren() != 0 || (blocks = ((SimpleNode)trySt.jjtGetChild(0)).findChildrenOfType(ASTBlockStatement.class)).isEmpty()) continue;
            ASTBlockStatement st = blocks.get(blocks.size() - 1);
            ASTName name = st.getFirstChildOfType(ASTName.class);
            if (name != null && st.equals(name.getNthParent(5)) && "fail".equals(name.getImage())) {
                found.add(name);
                continue;
            }
            ASTThrowStatement th = st.getFirstChildOfType(ASTThrowStatement.class);
            if (th == null || !st.equals(th.getNthParent(2))) continue;
            found.add(th);
        }
        return found;
    }

    private ASTCatchStatement getCatch(Node n) {
        for (int i = 0; i < n.jjtGetNumChildren(); ++i) {
            if (!(n.jjtGetChild(i) instanceof ASTCatchStatement)) continue;
            return (ASTCatchStatement)n.jjtGetChild(i);
        }
        return null;
    }
}

