/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.controller.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EntitiesChooserPanel
extends JPanel {
    private static final String BUNDLE = "org/dbuml/base/i18n/DBUML";
    private JPanel centerPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList leftList;
    private JButton moveAllLeftButton;
    private JButton moveAllRightButton;
    private JButton moveLeftButton;
    private JButton moveRightButton;
    private JLabel msgLabel;
    private JPanel operPanel;
    private JList rightList;

    public EntitiesChooserPanel() {
        this.initComponents();
    }

    public void initScreen(String[] data) {
        this.clearScreen();
        this.populateLeftList(data);
    }

    private void populateLeftList(String[] data) {
        MyListModel model = (MyListModel)this.leftList.getModel();
        model.addData(data);
        this.moveRightButton.setEnabled(false);
        this.moveLeftButton.setEnabled(false);
        this.moveAllLeftButton.setEnabled(false);
        this.moveAllRightButton.setEnabled(data.length > 0);
    }

    public String[] getChosenElements() {
        MyListModel model = (MyListModel)this.rightList.getModel();
        Object[] data = new String[model.getSize()];
        model.copyInto(data);
        return data;
    }

    public boolean hasChosenData() {
        return this.rightList.getModel().getSize() > 0;
    }

    private void clearScreen() {
        ListModel model = this.leftList.getModel();
        if (model instanceof MyListModel) {
            ((MyListModel)model).removeAllElements();
        }
        if ((model = this.rightList.getModel()) instanceof MyListModel) {
            ((MyListModel)model).removeAllElements();
        }
    }

    private void transferAllData(MyListModel from, MyListModel to) {
        to.addData(from.toArray());
        from.removeAllElements();
    }

    private void transferSelectedItems(JList from, JList to) {
        Object[] objs = from.getSelectedValues();
        MyListModel toModel = (MyListModel)to.getModel();
        toModel.addData(objs);
        MyListModel fromModel = (MyListModel)from.getModel();
        for (int i = 0; i < objs.length; ++i) {
            fromModel.removeElement(objs[i]);
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.msgLabel = new JLabel();
        this.centerPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.leftList = new JList();
        this.jPanel8 = new JPanel();
        this.jLabel3 = new JLabel();
        this.operPanel = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.moveRightButton = new JButton();
        this.moveLeftButton = new JButton();
        this.moveAllRightButton = new JButton();
        this.moveAllLeftButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.rightList = new JList();
        this.jPanel9 = new JPanel();
        this.jLabel4 = new JLabel();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(455, 223));
        this.setPreferredSize(new Dimension(455, 247));
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 1, 1, 1));
        this.msgLabel.setText(ResourceBundle.getBundle(BUNDLE).getString("MOVE_DATA_HINT"));
        this.jPanel2.add(this.msgLabel);
        this.add((Component)this.jPanel2, "North");
        this.centerPanel.setLayout(new GridLayout(1, 3));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLineBorder(new Color(0, 0, 0))));
        this.jPanel3.setMinimumSize(new Dimension(102, 167));
        this.jPanel3.setPreferredSize(new Dimension(102, 167));
        this.jScrollPane1.setMinimumSize(new Dimension(80, 65));
        this.jScrollPane1.setPreferredSize(new Dimension(80, 65));
        this.leftList.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.leftList.setModel(new MyListModel());
        this.leftList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                EntitiesChooserPanel.this.leftListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.leftList);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jLabel3.setText(ResourceBundle.getBundle(BUNDLE).getString("LIST_AVAIL"));
        this.jPanel8.add(this.jLabel3);
        this.jPanel3.add((Component)this.jPanel8, "North");
        this.centerPanel.add(this.jPanel3);
        this.operPanel.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new GridLayout(0, 3));
        this.jPanel7.add(this.jLabel1);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel6.setLayout(new GridLayout(4, 0));
        this.moveRightButton.setText(">");
        this.moveRightButton.setToolTipText(ResourceBundle.getBundle(BUNDLE).getString("MOVE_DATA_TO_RIGHT"));
        this.moveRightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesChooserPanel.this.moveRightButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.moveRightButton);
        this.moveLeftButton.setText("<");
        this.moveLeftButton.setToolTipText(ResourceBundle.getBundle(BUNDLE).getString("MOVE_DATA_TO_LEFT"));
        this.moveLeftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesChooserPanel.this.moveLeftButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.moveLeftButton);
        this.moveAllRightButton.setText(">>");
        this.moveAllRightButton.setToolTipText(ResourceBundle.getBundle(BUNDLE).getString("MOVE_ALL_DATA_TO_RIGHT"));
        this.moveAllRightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesChooserPanel.this.moveAllRightButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.moveAllRightButton);
        this.moveAllLeftButton.setText("<<");
        this.moveAllLeftButton.setToolTipText(ResourceBundle.getBundle(BUNDLE).getString("MOVE_ALL_DATA_TO_LEFT"));
        this.moveAllLeftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesChooserPanel.this.moveAllLeftButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.moveAllLeftButton);
        this.jPanel5.add((Component)this.jPanel6, "West");
        this.jPanel7.add(this.jPanel5);
        this.jPanel7.add(this.jLabel2);
        this.operPanel.add((Component)this.jPanel7, "Center");
        this.centerPanel.add(this.operPanel);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLineBorder(new Color(0, 0, 0))));
        this.jPanel4.setMinimumSize(new Dimension(102, 167));
        this.jPanel4.setPreferredSize(new Dimension(102, 167));
        this.jScrollPane2.setMinimumSize(new Dimension(80, 65));
        this.jScrollPane2.setPreferredSize(new Dimension(80, 65));
        this.rightList.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.rightList.setModel(new MyListModel());
        this.rightList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                EntitiesChooserPanel.this.rightListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.rightList);
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        this.jLabel4.setText(ResourceBundle.getBundle(BUNDLE).getString("LIST_IMPORT_CHOSEN"));
        this.jPanel9.add(this.jLabel4);
        this.jPanel4.add((Component)this.jPanel9, "North");
        this.centerPanel.add(this.jPanel4);
        this.add((Component)this.centerPanel, "Center");
    }

    private void rightListValueChanged(ListSelectionEvent evt) {
        this.moveLeftButton.setEnabled(this.rightList.getSelectedIndex() >= 0);
        evt.getFirstIndex();
    }

    private void leftListValueChanged(ListSelectionEvent evt) {
        this.moveRightButton.setEnabled(this.leftList.getSelectedIndex() >= 0);
        evt.getFirstIndex();
    }

    private void moveAllLeftButtonActionPerformed(ActionEvent evt) {
        this.transferAllData((MyListModel)this.rightList.getModel(), (MyListModel)this.leftList.getModel());
        this.moveAllRightButton.setEnabled(this.leftList.getModel().getSize() > 0);
        evt.getID();
    }

    private void moveAllRightButtonActionPerformed(ActionEvent evt) {
        this.transferAllData((MyListModel)this.leftList.getModel(), (MyListModel)this.rightList.getModel());
        this.moveAllLeftButton.setEnabled(this.rightList.getModel().getSize() > 0);
        evt.getID();
    }

    private void moveLeftButtonActionPerformed(ActionEvent evt) {
        this.transferSelectedItems(this.rightList, this.leftList);
        this.moveAllRightButton.setEnabled(this.leftList.getModel().getSize() > 0);
        evt.getID();
    }

    private void moveRightButtonActionPerformed(ActionEvent evt) {
        this.transferSelectedItems(this.leftList, this.rightList);
        this.moveAllLeftButton.setEnabled(this.rightList.getModel().getSize() > 0);
        evt.getID();
    }

    private static class MyListModel
    extends DefaultListModel {
        MyListModel() {
        }

        public void addData(Object[] objs) {
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    this.addElement(objs[i]);
                }
            }
        }
    }
}

