/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.application;

import com.jgoodies.application.Application;
import com.jgoodies.application.ExitListener;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.framework.util.ScreenUtils;
import com.jgoodies.jdiskreport.gui.application.JDApplicationModel;
import com.jgoodies.jdiskreport.gui.application.JDNavigationView;
import com.jgoodies.jdiskreport.gui.application.JDPresentationView;
import com.jgoodies.jdiskreport.gui.application.JDResultAppBar;
import com.jgoodies.jdiskreport.gui.application.JDResultDetailsView;
import com.jgoodies.jdiskreport.gui.application.JDResultModel;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.navigation.Page;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

final class JDResultPage
extends Page.BasicPage
implements ExitListener {
    private static final Dimension NAVIGATION_MINIMUM_SIZE = ScreenScaling.physicalDimension(150, 90);
    private static final Dimension NAVIGATION_PREFERRED_SIZE = ScreenScaling.physicalDimension(300, 200);
    private static final Dimension PRESENTATION_MINIMUM_SIZE = ScreenScaling.physicalDimension(190, 90);
    private static final String KEY_MAIN_DIVIDER_LOCATION = "main.divider_location";
    private final JDApplicationModel applicationModel;
    private final JDResultModel resultModel;
    private JSplitPane splitPane;
    private JComponent detailsPanel;

    JDResultPage(JDApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.resultModel = applicationModel.getResultModel();
        this.setContent(this::buildContent);
        this.initComponents();
        this.initEventHandling();
    }

    private void initComponents() {
        this.detailsPanel = new JDResultDetailsView(this.resultModel).buildPanel();
    }

    private void initEventHandling() {
        this.resultModel.addPropertyChangeListener("detailsVisible", this::onDetailsVisibleChanged);
        this.onDetailsVisibleChanged(null);
        Application.getInstance().addExitListener(this);
    }

    private void onDetailsVisibleChanged(PropertyChangeEvent ignored) {
        this.detailsPanel.setVisible(this.resultModel.isDetailsVisible());
    }

    @Override
    public void applicationExited() {
        Preferences prefs = Application.getInstance().getContext().getUserPreferences();
        this.storeState(prefs);
    }

    private JComponent buildContent() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:0:grow", new Object[0])).rows("f:48epx, f:200epx:g, p", new Object[0])).add(this.buildTopAppBar()).xy(1, 1)).add(this.buildSplitPane()).xy(1, 2)).add(this.detailsPanel).xy(1, 3)).build();
    }

    private JComponent buildTopAppBar() {
        return new JDResultAppBar(this.applicationModel).buildAll();
    }

    private JComponent buildSplitPane() {
        JComponent leftPane = this.buildNavigation();
        JComponent rightPane = this.buildPresentation();
        leftPane.setBorder(null);
        rightPane.setBorder(null);
        leftPane.setMinimumSize(NAVIGATION_MINIMUM_SIZE);
        leftPane.setPreferredSize(NAVIGATION_PREFERRED_SIZE);
        rightPane.setMinimumSize(PRESENTATION_MINIMUM_SIZE);
        this.splitPane = JGComponentFactory.getCurrent().createSplitPane(1, leftPane, rightPane);
        this.splitPane.setOpaque(true);
        this.restoreState(Application.getInstance().getContext().getUserPreferences());
        return this.splitPane;
    }

    private JComponent buildNavigation() {
        return new JDNavigationView(this.resultModel.getNavigationModel()).buildPanel();
    }

    private JComponent buildPresentation() {
        return new JDPresentationView(this.resultModel).buildPanel();
    }

    private void restoreState(Preferences prefs) {
        Preferences screenConfigNode = ScreenUtils.screenConfigurationNode(prefs);
        int location = screenConfigNode.getInt(KEY_MAIN_DIVIDER_LOCATION, this.getDefaultDividerLocation());
        Container parent = this.getPanel().getParent();
        int parentWidth = parent == null ? Integer.MAX_VALUE : parent.getWidth();
        int maxLocation = parentWidth - this.splitPane.getDividerSize() - JDResultPage.PRESENTATION_MINIMUM_SIZE.width;
        this.splitPane.setDividerLocation(Math.min(location, maxLocation));
    }

    void storeState(Preferences prefs) {
        Preferences screenConfigNode = ScreenUtils.screenConfigurationNode(prefs);
        screenConfigNode.putInt(KEY_MAIN_DIVIDER_LOCATION, this.splitPane.getDividerLocation());
    }

    private int getDefaultDividerLocation() {
        Container parent = this.getPanel().getParent();
        int parentWidth = parent == null ? Integer.MAX_VALUE : parent.getWidth();
        return (int)Math.min((double)ScreenScaling.toPhysical(200), (double)parentWidth * 0.3);
    }
}

