/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.settings;

import com.jgoodies.common.bean.Bean;
import com.jgoodies.jdiskreport.gui.settings.ChartSettings;
import java.util.prefs.Preferences;

public final class GUISettings
extends Bean {
    public static final String PROPERTY_BOLDNESS_THRESHOD = "boldnessThreshold";
    public static final String PROPERTY_COLLAPSE_DESELECTED_PATHS = "collapseDeselectedPaths";
    public static final String PROPERTY_EXPAND_SELECTED_PATHS = "expandSelectedPaths";
    public static final String PROPERTY_STATISTICS_DEPTH = "statisticsDepth";
    public static final String PROPERTY_SORT_MODE = "sortMode";
    public static final String PROPERTY_SIZE_MODE = "sizeMode";
    public static final String PROPERTY_SHOW_FILES = "showFiles";
    public static final String PROPERTY_NODE_MODE = "nodeMode";
    public static final String PROPERTY_VIEW_MODE = "viewMode";
    private static final float DEFAULT_BOLDNESS_THRESHOLD = 0.1f;
    static final float MIN_BOLDNESS_THRESHOLD = 0.0f;
    static final float MAX_BOLDNESS_THRESHOLD = 1.0f;
    private static final boolean DEFAULT_COLLAPSE_DESELECTED_PATHS = true;
    private static final boolean DEFAULT_EXPAND_SELECTED_PATHS = true;
    private static final SortMode DEFAULT_SORT_MODE = SortMode.BY_SIZE;
    private static final SizeMode DEFAULT_SIZE_MODE = SizeMode.SIZE;
    private static final NodeMode DEFAULT_NODE_MODE = NodeMode.PLAIN;
    private static final ViewMode DEFAULT_VIEW_MODE = ViewMode.SIZE_PIE;
    private static final boolean DEFAULT_SHOW_FILES = true;
    public static final int MIN_STATISTICS_DEPTH = 2;
    private static final int DEFAULT_STATISTICS_DEPTH = 3;
    public static final int MAX_STATISTICS_DEPTH = 8;
    private final ChartSettings chartSettings;
    private float boldnessThreshold = 0.1f;
    private boolean collapseDeselectedPaths = true;
    private boolean expandSelectedPaths = true;
    private SortMode sortMode = DEFAULT_SORT_MODE;
    private SizeMode sizeMode = DEFAULT_SIZE_MODE;
    private NodeMode nodeMode = DEFAULT_NODE_MODE;
    private ViewMode viewMode = DEFAULT_VIEW_MODE;
    private boolean showFiles = true;
    private int statisticsDepth = 3;
    private static final String KEY_BOLDNESS_THRESHOLD = "boldness_threshold";
    private static final String KEY_COLLAPSE_DESELECTED_PATHS = "collapse_deselected_paths";
    private static final String KEY_EXPAND_SELECTED_PATHS = "expand_selected_paths";
    private static final String KEY_SORT_MODE = "sort_mode";
    private static final String KEY_SIZE_MODE = "size_mode";
    private static final String KEY_NODE_MODE = "node_mode";
    private static final String KEY_VIEW_MODE = "view_mode";
    private static final String KEY_SHOW_FILES = "show_files";
    private static final String KEY_STATISTICS_DEPTH = "statistics.depth";

    public GUISettings() {
        this.chartSettings = new ChartSettings();
    }

    public ChartSettings chartSettings() {
        return this.chartSettings;
    }

    public float getBoldnessThreshold() {
        return this.boldnessThreshold;
    }

    public void setBoldnessThreshold(float newValue) {
        float oldValue = this.getBoldnessThreshold();
        this.boldnessThreshold = newValue;
        this.firePropertyChange(PROPERTY_BOLDNESS_THRESHOD, oldValue, newValue);
    }

    public boolean getCollapseDeselectedPaths() {
        return this.collapseDeselectedPaths;
    }

    public void setCollapseDeselectedPaths(boolean newValue) {
        boolean oldValue = this.getCollapseDeselectedPaths();
        this.collapseDeselectedPaths = newValue;
        this.firePropertyChange(PROPERTY_COLLAPSE_DESELECTED_PATHS, oldValue, newValue);
    }

    public boolean getExpandSelectedPaths() {
        return this.expandSelectedPaths;
    }

    public void setExpandSelectedPaths(boolean newValue) {
        boolean oldValue = this.getExpandSelectedPaths();
        this.expandSelectedPaths = newValue;
        this.firePropertyChange(PROPERTY_EXPAND_SELECTED_PATHS, oldValue, newValue);
    }

    public SortMode getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(SortMode newMode) {
        SortMode oldMode = this.getSortMode();
        this.sortMode = newMode;
        this.firePropertyChange(PROPERTY_SORT_MODE, (Object)oldMode, (Object)newMode);
    }

    public SizeMode getSizeMode() {
        return this.sizeMode;
    }

    public void setSizeMode(SizeMode newMode) {
        SizeMode oldMode = this.getSizeMode();
        this.sizeMode = newMode;
        this.firePropertyChange(PROPERTY_SIZE_MODE, (Object)oldMode, (Object)newMode);
    }

    public NodeMode getNodeMode() {
        return this.nodeMode;
    }

    public void setNodeMode(NodeMode newMode) {
        NodeMode oldMode = this.getNodeMode();
        this.nodeMode = newMode;
        this.firePropertyChange(PROPERTY_NODE_MODE, (Object)oldMode, (Object)newMode);
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(ViewMode newMode) {
        ViewMode oldMode = this.getViewMode();
        this.viewMode = newMode;
        this.firePropertyChange(PROPERTY_VIEW_MODE, (Object)oldMode, (Object)newMode);
    }

    public boolean getShowFiles() {
        return this.showFiles;
    }

    public void setShowFiles(boolean newValue) {
        boolean oldValue = this.getShowFiles();
        this.showFiles = newValue;
        this.firePropertyChange(PROPERTY_SHOW_FILES, oldValue, newValue);
    }

    public int getStatisticsDepth() {
        return this.statisticsDepth;
    }

    public void setStatisticsDepth(int newDepth) {
        int oldDepth = this.getStatisticsDepth();
        this.statisticsDepth = newDepth;
        this.firePropertyChange(PROPERTY_STATISTICS_DEPTH, oldDepth, newDepth);
    }

    public void restoreFrom(Preferences prefs) {
        this.chartSettings().restoreFrom(prefs);
        this.setBoldnessThreshold(GUISettings.boundedValue(prefs.getFloat(KEY_BOLDNESS_THRESHOLD, -1.0f), 0.0f, 1.0f, 0.1f));
        this.setCollapseDeselectedPaths(prefs.getBoolean(KEY_COLLAPSE_DESELECTED_PATHS, true));
        this.setExpandSelectedPaths(prefs.getBoolean(KEY_EXPAND_SELECTED_PATHS, true));
        this.setSortMode(SortMode.valueOf(prefs.get(KEY_SORT_MODE, "")));
        this.setSizeMode(SizeMode.valueOf(prefs.get(KEY_SIZE_MODE, "")));
        this.setNodeMode(NodeMode.valueOf(prefs.get(KEY_NODE_MODE, "")));
        this.setViewMode(ViewMode.valueOf(prefs.get(KEY_VIEW_MODE, "")));
        this.setShowFiles(prefs.getBoolean(KEY_SHOW_FILES, true));
        this.setStatisticsDepth(GUISettings.boundedValue(prefs.getInt(KEY_STATISTICS_DEPTH, -1), 2, 8, 3));
    }

    public void storeIn(Preferences prefs) {
        this.chartSettings().storeIn(prefs);
        prefs.putFloat(KEY_BOLDNESS_THRESHOLD, this.getBoldnessThreshold());
        prefs.putBoolean(KEY_COLLAPSE_DESELECTED_PATHS, this.getCollapseDeselectedPaths());
        prefs.putBoolean(KEY_EXPAND_SELECTED_PATHS, this.getExpandSelectedPaths());
        prefs.put(KEY_SORT_MODE, this.getSortMode().name());
        prefs.put(KEY_SIZE_MODE, this.getSizeMode().name());
        prefs.put(KEY_NODE_MODE, this.getNodeMode().name());
        prefs.put(KEY_VIEW_MODE, this.getViewMode().name());
        prefs.putBoolean(KEY_SHOW_FILES, this.getShowFiles());
        prefs.put(KEY_SORT_MODE, this.getSortMode().name());
        prefs.putInt(KEY_STATISTICS_DEPTH, this.getStatisticsDepth());
    }

    private static float boundedValue(float f, float min, float max, float defaultValue) {
        return min <= f && f <= max ? f : defaultValue;
    }

    private static int boundedValue(int i, int min, int max, int defaultValue) {
        return min <= i && i <= max ? i : defaultValue;
    }

    public static enum NodeMode {
        PLAIN,
        SIZE,
        PERCENT;

    }

    public static enum SizeMode {
        SIZE,
        COUNT;

    }

    public static enum SortMode {
        BY_SIZE,
        BY_NAME;

    }

    public static enum ViewMode {
        SIZE_SUNBURST,
        SIZE_TREE_MAP,
        SIZE_PIE,
        SIZE_BAR,
        SIZE_TABLE,
        TOP50_LARGEST,
        TOP50_LEAST_RECENTLY_MODIFIED,
        TOP50_MOST_RECENTLY_MODIFIED,
        TOP50_LEAST_RECENTLY_ACCESSED,
        TOP50_MOST_RECENTLY_ACCESSED,
        TOP50_LEAST_RECENTLY_USED,
        TOP50_MOST_RECENTLY_USED,
        SIZE_DISTRIBUTION_PIE,
        SIZE_DISTRIBUTION_BAR,
        SIZE_DISTRIBUTION_TABLE,
        MODIFIED_DISTRIBUTION_PIE,
        MODIFIED_DISTRIBUTION_BAR,
        MODIFIED_DISTRIBUTION_TABLE,
        ACCESSED_DISTRIBUTION_PIE,
        ACCESSED_DISTRIBUTION_BAR,
        ACCESSED_DISTRIBUTION_TABLE,
        TYPE_DISTRIBUTION_PIE,
        TYPE_DISTRIBUTION_BAR,
        TYPE_DISTRIBUTION_TABLE;

    }
}

