/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.quicksearch;

import com.jgoodies.quicksearch.QuickSearchManager;
import java.util.EventObject;

public final class QuickSearchProcessEvent
extends EventObject {
    private final State state;

    QuickSearchProcessEvent(QuickSearchManager manager, State state) {
        super(manager);
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public boolean isStarted() {
        return this.state == State.PROCESS_STARTED;
    }

    public boolean isStopped() {
        return this.isSucceeded() || this.isCancelled();
    }

    public boolean isCancelled() {
        return this.state == State.PROCESS_CANCELLED;
    }

    public boolean isSucceeded() {
        return this.state == State.PROCESS_SUCCEEDED;
    }

    public boolean isChanged() {
        return this.state == State.RESULT_CHANGED;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[state=" + (Object)((Object)this.getState()) + "]";
    }

    public static enum State {
        PROCESS_STARTED,
        PROCESS_CANCELLED,
        RESULT_CHANGED,
        PROCESS_SUCCEEDED;

    }
}

