/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.search;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.search.Completion;
import com.jgoodies.search.CompletionManager;
import java.util.EventObject;
import java.util.List;
import javax.swing.text.JTextComponent;

public final class CompletionProcessEvent
extends EventObject {
    private final CompletionManager completionManager;
    private final State state;
    private final List<? extends Completion> completions;

    CompletionProcessEvent(JTextComponent textComponent, CompletionManager completionManager, State state, List<? extends Completion> completions) {
        super(textComponent);
        this.completionManager = completionManager;
        this.state = state;
        this.completions = completions;
    }

    public CompletionManager getCompletionManager() {
        return this.completionManager;
    }

    public JTextComponent getTextComponent() {
        return (JTextComponent)this.getSource();
    }

    public State getState() {
        return this.state;
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public boolean isStopped() {
        return this.isSucceeded() || this.isCancelled();
    }

    public boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    public boolean isSucceeded() {
        return this.state == State.SUCCEEDED;
    }

    public List<? extends Completion> getCompletions() {
        Preconditions.checkState(this.state == State.SUCCEEDED, "Completions can be requested only for CompletionProcessEvents in SUCCEEDED state.");
        return this.completions;
    }

    public boolean hasCompletions() {
        return this.completions != null && this.completions.size() > 0;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        StringBuilder builder = new StringBuilder();
        builder.append("source=");
        builder.append(this.getSource());
        builder.append(", state=");
        builder.append((Object)this.getState());
        builder.append(", manager=");
        builder.append(this.getCompletionManager());
        builder.append(", hasCompletions=");
        builder.append(this.hasCompletions());
        return builder.toString();
    }

    public static enum State {
        STARTED,
        CANCELLED,
        SUCCEEDED;

    }
}

