/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.util.Collection;
import java.util.Collections;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.FormatManager;

public final class FactSetKey<T> {
    private static CaseInsensitiveMap<FactSetKey<?>> typeMap = new CaseInsensitiveMap();
    private final String fieldName;
    private final FormatManager<T> formatManager;

    private FactSetKey(String name, FormatManager<T> mgr) {
        if (name == null) {
            throw new IllegalArgumentException("Name for FactSetKey cannot be null");
        }
        if (mgr == null) {
            throw new IllegalArgumentException("FormatManager for FactSetKey cannot be null");
        }
        this.fieldName = name;
        this.formatManager = mgr;
    }

    public String toString() {
        return this.fieldName;
    }

    public static <T> FactSetKey<T> getConstant(String name, FormatManager<T> cl) {
        FactSetKey<T> key = (FactSetKey<T>)typeMap.get((Object)name);
        if (key == null) {
            key = new FactSetKey<T>(name, cl);
            typeMap.put((Object)name, key);
        } else if (!key.formatManager.equals(cl)) {
            throw new IllegalArgumentException("FactSetKey: " + name + " does not store objects of " + cl.getManagedClass().getCanonicalName());
        }
        return key;
    }

    public static <T> FactSetKey<T> valueOf(String name) {
        FactSetKey key = (FactSetKey)typeMap.get((Object)name);
        if (key == null) {
            throw new IllegalArgumentException(name + " is not a previously defined FactSetKey");
        }
        return key;
    }

    public static Collection<FactSetKey<?>> getAllConstants() {
        return Collections.unmodifiableCollection(typeMap.values());
    }

    public static void clearConstants() {
        typeMap.clear();
    }

    public T cast(Object obj) {
        return (T)obj;
    }

    public FormatManager<T> getFormatManager() {
        return this.formatManager;
    }
}

