/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ItemFacet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.output.publish.OutputDB;

public class HasAnyFavoredClassFacet
extends AbstractSourcedListFacet<CharID, Boolean>
implements DataFacetChangeListener<CharID, CDOMObject>,
ItemFacet<CharID, Boolean> {
    private RaceFacet raceFacet;
    private TemplateFacet templateFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        Boolean hdw = cdo.get(ObjectKey.ANY_FAVORED_CLASS);
        if (hdw != null) {
            this.add(dfce.getCharID(), hdw, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public void init() {
        this.raceFacet.addDataFacetChangeListener(this);
        this.templateFacet.addDataFacetChangeListener(this);
        OutputDB.register("hasanyfavoredclass", this);
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    @Override
    public Boolean get(CharID id) {
        return this.contains(id, Boolean.TRUE);
    }
}

