/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.SubClass;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class ClassSkillChoiceActor
implements PersistentChoiceActor<Skill> {
    private final PCClass source;
    private final Integer applyRank;

    public ClassSkillChoiceActor(PCClass pcc, Integer autoRank) {
        this.applyRank = autoRank;
        this.source = pcc;
    }

    @Override
    public void applyChoice(CDOMObject owner, Skill choice, PlayerCharacter pc) {
        PCClass pcc = this.getSourceClass(pc);
        if (pcc == null) {
            Logging.errorPrint("Unable to find the pc's class " + this.source + " to apply skill choices to.");
            return;
        }
        pc.addLocalCost(pcc, choice, SkillCost.CLASS, owner);
        if (this.applyRank != null) {
            String result;
            if (owner instanceof PCClassLevel) {
                PCClassLevel classLevel = (PCClassLevel)owner;
                PCClass pcClass = (PCClass)classLevel.getSafe(ObjectKey.PARENT);
                int levelIndex = 1;
                for (PCLevelInfo lvlInfo : pc.getLevelInfo()) {
                    if (lvlInfo.getClassKeyName() != pcClass.getKeyName() || lvlInfo.getClassLevel() != classLevel.getSafe(IntegerKey.LEVEL)) continue;
                    pc.checkSkillModChangeForLevel(pcClass, lvlInfo, classLevel, levelIndex++);
                    break;
                }
            }
            if (StringUtils.isNotEmpty(result = SkillRankControl.modRanks(this.applyRank.intValue(), pcc, false, pc, choice))) {
                Logging.errorPrint("Unable to apply {0} ranks of {1}. Error: {2}", this.applyRank, choice, result);
            }
        }
    }

    @Override
    public boolean allow(Skill choice, PlayerCharacter pc, boolean allowStack) {
        return !pc.isClassSkill(this.source, choice);
    }

    @Override
    public Skill decodeChoice(LoadContext context, String persistentFormat) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, persistentFormat);
    }

    @Override
    public String encodeChoice(Skill choice) {
        return choice.getKeyName();
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, Skill choice) {
        PCClass pcc = this.getSourceClass(pc);
        if (pcc == null) {
            Logging.errorPrint("Unable to find the pc's class " + this.source + " to restore skill choices to.");
            return;
        }
        pc.addLocalCost(pcc, choice, SkillCost.CLASS, owner);
    }

    private PCClass getSourceClass(PlayerCharacter pc) {
        PCClass pcc = this.source instanceof SubClass ? pc.getClassKeyed(((SubClass)this.source).getCDOMCategory().getKeyName()) : pc.getClassKeyed(this.source.getKeyName());
        return pcc;
    }

    public Integer getApplyRank() {
        return this.applyRank;
    }

    @Override
    public void removeChoice(PlayerCharacter pc, CDOMObject owner, Skill choice) {
        PCClass pcc = pc.getClassKeyed(this.source.getKeyName());
        if (this.applyRank != null) {
            SkillRankControl.modRanks(-this.applyRank.intValue(), pcc, false, pc, choice);
        }
        pc.removeLocalCost(pcc, choice, SkillCost.CLASS, owner);
    }
}

