/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.primitive;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.primitive.PrimitiveUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.util.Logging;

public class CompoundAndPrimitive<T>
implements PrimitiveCollection<T> {
    private final Class<? super T> refClass;
    private final Set<PrimitiveCollection<T>> primCollection = new TreeSet(PrimitiveUtilities.COLLECTION_SORTER);

    public CompoundAndPrimitive(Collection<PrimitiveCollection<T>> pcfCollection) {
        if (pcfCollection == null) {
            throw new IllegalArgumentException("Collection for CompoundAndPrimitive cannot be null");
        }
        if (pcfCollection.isEmpty()) {
            throw new IllegalArgumentException("Collection for CompoundAndPrimitive cannot be empty");
        }
        Class<T> pcfClass = null;
        this.primCollection.addAll(pcfCollection);
        if (this.primCollection.size() != pcfCollection.size()) {
            if (Logging.isLoggable(Level.WARNING)) {
                Logging.log(Level.WARNING, "Found duplicate item in " + pcfCollection);
            }
            this.primCollection.add(PrimitiveCollection.FIXED.invalid());
        }
        for (PrimitiveCollection<T> pcf : this.primCollection) {
            Class<T> thisPCFClass = pcf.getReferenceClass();
            if (pcfClass == null) {
                pcfClass = thisPCFClass;
                continue;
            }
            if (pcfClass.isAssignableFrom(thisPCFClass)) continue;
            if (thisPCFClass.isAssignableFrom(pcfClass)) {
                pcfClass = thisPCFClass;
                continue;
            }
            throw new IllegalArgumentException("List contains incompatible types: " + pcfClass.getSimpleName() + " and " + thisPCFClass.getSimpleName());
        }
        this.refClass = pcfClass;
    }

    @Override
    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<T, R> c) {
        Collection<R> returnSet = null;
        for (PrimitiveCollection<T> cs : this.primCollection) {
            if (returnSet == null) {
                returnSet = cs.getCollection(pc, c);
                continue;
            }
            returnSet.retainAll(cs.getCollection(pc, c));
        }
        return returnSet;
    }

    @Override
    public Class<? super T> getReferenceClass() {
        return this.refClass;
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState state = GroupingState.EMPTY;
        for (PrimitiveCollection<T> pcs : this.primCollection) {
            state = pcs.getGroupingState().add(state);
        }
        return state.compound(GroupingState.ALLOWS_INTERSECTION);
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return PrimitiveUtilities.joinLstFormat(this.primCollection, ",", useAny);
    }

    public int hashCode() {
        return this.primCollection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CompoundAndPrimitive && ((CompoundAndPrimitive)obj).primCollection.equals(this.primCollection);
    }
}

