/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pcgen.cdom.base.BonusContainer;
import pcgen.cdom.base.TransitionChoice;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.BonusObj;

public class AgeSet
implements BonusContainer {
    private List<BonusObj> bonuses = null;
    private List<TransitionChoice<Kit>> kits = null;
    private final String name;
    private final int index;

    public AgeSet(String ageName, int currentAgeSetIndex) {
        this.name = ageName;
        this.index = currentAgeSetIndex;
    }

    public void addBonuses(List<BonusObj> list) {
        if (this.bonuses == null) {
            this.bonuses = new ArrayList<BonusObj>(list);
        }
    }

    public boolean hasBonuses() {
        return this.bonuses != null && !this.bonuses.isEmpty();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public List<BonusObj> getBonuses() {
        if (this.bonuses == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.bonuses);
    }

    public void addKits(List<TransitionChoice<Kit>> list) {
        if (this.kits == null) {
            this.kits = new ArrayList<TransitionChoice<Kit>>(list);
        }
    }

    public List<TransitionChoice<Kit>> getKits() {
        if (this.kits == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.kits);
    }

    public String getLSTformat() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.index).append('|').append(this.name);
        if (this.bonuses != null) {
            for (BonusObj bonusObj : this.bonuses) {
                sb.append('\t').append(bonusObj.getLSTformat());
            }
        }
        if (this.kits != null) {
            for (TransitionChoice transitionChoice : this.kits) {
                sb.append('\t').append(transitionChoice.getCount()).append("|");
                sb.append(transitionChoice.getChoices().getLSTformat().replaceAll(",", "|"));
            }
        }
        return sb.toString();
    }

    @Override
    public void activateBonuses(PlayerCharacter pc) {
        if (this.bonuses != null) {
            for (BonusObj bo : this.bonuses) {
                pc.setApplied(bo, bo.qualifies(pc, null));
            }
        }
    }

    @Override
    public List<BonusObj> getActiveBonuses(PlayerCharacter pc) {
        if (this.bonuses == null) {
            return Collections.emptyList();
        }
        ArrayList<BonusObj> aList = new ArrayList<BonusObj>();
        for (BonusObj bo : this.bonuses) {
            if (!pc.isApplied(bo)) continue;
            aList.add(bo);
        }
        return aList;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AgeSet) {
            AgeSet other = (AgeSet)o;
            if (this.bonuses == null ? other.bonuses != null : !this.bonuses.equals(other.bonuses)) {
                return false;
            }
            if (this.kits == null ? other.kits != null : !this.kits.equals(other.kits)) {
                return false;
            }
            return this.index == other.index && this.name.equals(other.name);
        }
        return false;
    }
}

