/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.helper.ClassSource;
import pcgen.core.Ability;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.analysis.SpellCountCalc;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;

public final class CharacterSpell
implements Comparable<CharacterSpell> {
    private final List<SpellInfo> infoList = new ArrayList<SpellInfo>();
    private final CDOMObject owner;
    private final Spell spell;
    private String fixedCasterLevel = null;

    public CharacterSpell(CDOMObject o, Spell aSpell) {
        this.owner = o;
        this.spell = aSpell;
    }

    public int getInfoIndexFor(PlayerCharacter pc, String bookName, int level, int specialty) {
        boolean sp;
        if (this.infoList.isEmpty()) {
            return -1;
        }
        boolean bl = sp = specialty == 1;
        if (sp) {
            sp = this.isSpecialtySpell(pc);
        }
        int i = 0;
        for (SpellInfo s : this.infoList) {
            if (!(!"".equals(bookName) && !bookName.equals(s.getBook()) || level != -1 && s.getActualLevel() != level || specialty != -1 && !sp)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<SpellInfo> getInfoList() {
        return this.infoList;
    }

    public CDOMObject getOwner() {
        return this.owner;
    }

    public boolean isSpecialtySpell(PlayerCharacter pc) {
        boolean result;
        if (this.spell == null) {
            result = false;
        } else if (this.owner instanceof Domain) {
            result = true;
        } else if (this.owner instanceof PCClass) {
            PCClass a = (PCClass)this.owner;
            result = SpellCountCalc.isSpecialtySpell(pc, a, this.spell);
        } else {
            result = false;
        }
        return result;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public SpellInfo getSpellInfoFor(String bookName, int level) {
        return this.getSpellInfoFor(bookName, level, null);
    }

    public SpellInfo getSpellInfoFor(String bookName, int level, List<Ability> featList) {
        if (this.infoList.isEmpty()) {
            return null;
        }
        for (SpellInfo s : this.infoList) {
            if (!"".equals(bookName) && !bookName.equals(s.getBook()) || level != -1 && s.getActualLevel() != level || featList != null && (!featList.isEmpty() || s.getFeatList() != null && !s.getFeatList().isEmpty()) && (s.getFeatList() == null || !featList.toString().equals(s.getFeatList().toString()))) continue;
            return s;
        }
        return null;
    }

    public boolean hasSpellInfoFor(int level) {
        if (this.infoList.isEmpty()) {
            return false;
        }
        for (SpellInfo s : this.infoList) {
            if (s.getActualLevel() != level) continue;
            return true;
        }
        return false;
    }

    public boolean hasSpellInfoFor(String bookName) {
        if (this.infoList.isEmpty()) {
            return false;
        }
        for (SpellInfo s : this.infoList) {
            if (!bookName.equals(s.getBook())) continue;
            return true;
        }
        return false;
    }

    public SpellInfo addInfo(int level, int times, String book) {
        return this.addInfo(level, level, times, book, null);
    }

    public SpellInfo addInfo(int origLevel, int level, int times, String book, List<Ability> featList) {
        SpellInfo si = new SpellInfo(this, origLevel, level, times, book);
        if (featList != null) {
            si.addFeatsToList(featList);
        }
        this.infoList.add(si);
        return si;
    }

    @Override
    public int compareTo(CharacterSpell obj) {
        int compare = this.spell.compareTo(obj.spell);
        if (compare == 0) {
            if (this.fixedCasterLevel == null) {
                if (obj.fixedCasterLevel != null) {
                    compare = -1;
                }
            } else {
                compare = obj.fixedCasterLevel == null ? 1 : this.fixedCasterLevel.compareTo(obj.fixedCasterLevel);
            }
        }
        if (compare == 0) {
            compare = this.owner.getClass().toString().compareTo(obj.owner.getClass().toString());
        }
        if (compare == 0) {
            compare = this.owner.getKeyName().compareTo(obj.owner.getKeyName());
        }
        if (compare == 0) {
            int otherILsize;
            int thisILsize = this.infoList.size();
            if (thisILsize < (otherILsize = obj.infoList.size())) {
                compare = -1;
            } else if (thisILsize > otherILsize) {
                compare = 1;
            } else {
                for (int i = 0; i < thisILsize && (compare = this.infoList.get(i).compareTo(obj.infoList.get(i))) == 0; ++i) {
                }
            }
        }
        return compare;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof CharacterSpell && ((CharacterSpell)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void removeSpellInfo(SpellInfo x) {
        if (x != null) {
            this.infoList.remove(x);
        }
    }

    public String toString() {
        String result = this.spell == null ? "" : this.spell.getDisplayName();
        return result;
    }

    private String getName() {
        StringBuilder buf = new StringBuilder(this.owner.toString());
        if (this.spell != null) {
            buf.append(':').append(this.spell.getDisplayName());
        }
        return buf.toString();
    }

    public String getFixedCasterLevel() {
        return this.fixedCasterLevel;
    }

    public void setFixedCasterLevel(String fixedCasterLevel) {
        this.fixedCasterLevel = fixedCasterLevel;
    }

    public String getVariableSource(PlayerCharacter pc) {
        if (this.owner instanceof Domain) {
            ClassSource source = pc.getDomainSource((Domain)this.owner);
            if (source != null) {
                return "CLASS:" + pc.getClassKeyed(source.getPcclass().getKeyName());
            }
        } else {
            if (this.owner instanceof PCClass) {
                return "CLASS:" + this.owner.getKeyName();
            }
            if (this.owner instanceof Race) {
                return "RACE:" + this.owner.getKeyName();
            }
        }
        return "";
    }
}

