/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCAlignment;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.RaceAlignment;
import pcgen.core.kit.BaseKit;

public class KitAlignment
extends BaseKit {
    private List<CDOMSingleRef<PCAlignment>> alignments;
    private transient PCAlignment align = null;

    @Override
    public void apply(PlayerCharacter aPC) {
        aPC.setAlignment(this.align);
    }

    @Override
    public boolean testApply(Kit k, PlayerCharacter aPC, List<String> warnings) {
        this.align = null;
        if (this.alignments.size() == 1) {
            this.align = this.alignments.get(0).resolvesTo();
        } else {
            List sel;
            ArrayList<PCAlignment> available = new ArrayList<PCAlignment>(this.alignments.size());
            for (CDOMSingleRef<PCAlignment> ref : this.alignments) {
                available.add(ref.resolvesTo());
            }
            do {
                sel = new ArrayList(1);
            } while ((sel = Globals.getChoiceFromList("Choose alignment", available, sel, 1, aPC)).size() != 1);
            this.align = (PCAlignment)sel.get(0);
        }
        this.apply(aPC);
        return RaceAlignment.canBeAlignment(aPC.getRace(), this.align);
    }

    @Override
    public String getObjectName() {
        return "Alignment";
    }

    public String toString() {
        if (this.alignments == null || this.alignments.isEmpty()) {
            return "";
        }
        if (this.alignments.size() == 1) {
            return this.alignments.get(0).resolvesTo().getDisplayName();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("One of (");
        boolean needComma = false;
        for (CDOMSingleRef<PCAlignment> alref : this.alignments) {
            PCAlignment al = alref.resolvesTo();
            if (needComma) {
                buf.append(", ");
            }
            needComma = true;
            buf.append(al.getDisplayName());
        }
        buf.append(")");
        return buf.toString();
    }

    public void addAlignment(CDOMSingleRef<PCAlignment> ref) {
        if (this.alignments == null) {
            this.alignments = new ArrayList<CDOMSingleRef<PCAlignment>>();
        }
        this.alignments.add(ref);
    }

    public List<CDOMSingleRef<PCAlignment>> getAlignments() {
        return this.alignments;
    }
}

