/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.pclevelinfo;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.lang.ObjectUtil;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.PointBuyMethod;
import pcgen.core.SettingsHandler;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;
import pcgen.core.pclevelinfo.PCLevelInfoStat;

public final class PCLevelInfo
implements Cloneable {
    private List<PCLevelInfoStat> statsPostModified = null;
    private List<PCLevelInfoStat> statsPreModified = null;
    private String classKeyName = "";
    private int classLevel = 0;
    private int skillPointsGained = Integer.MIN_VALUE;
    private int skillPointsRemaining = 0;

    public PCLevelInfo(String argClassKeyName) {
        this.classKeyName = argClassKeyName;
    }

    public void setClassKeyName(String argClassKeyName) {
        this.classKeyName = argClassKeyName;
    }

    public String getClassKeyName() {
        return this.classKeyName;
    }

    public void setClassLevel(int arg) {
        this.classLevel = arg;
    }

    public int getClassLevel() {
        return this.classLevel;
    }

    public List<PCLevelInfoStat> getModifiedStats(boolean preMod) {
        List<PCLevelInfoStat> result = this.statsPostModified;
        if (preMod) {
            result = this.statsPreModified;
        }
        return result;
    }

    public void setSkillPointsGained(PlayerCharacter aPC, int arg) {
        int bonusPoints = this.getBonusSkillPool(aPC);
        this.setFixedSkillPointsGained(arg + bonusPoints);
    }

    public int getSkillPointsGained(PlayerCharacter pc) {
        if (this.skillPointsGained == Integer.MIN_VALUE && this.classKeyName.length() > 0) {
            PCClass aClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, this.classKeyName);
            this.skillPointsGained = pc.recalcSkillPointMod(aClass, this.classLevel) + this.getBonusSkillPool(pc);
        }
        return this.skillPointsGained;
    }

    public void setSkillPointsRemaining(int points) {
        this.skillPointsRemaining = points;
    }

    public int getSkillPointsRemaining() {
        return this.skillPointsRemaining;
    }

    public int getTotalStatMod(PCStat aStat, boolean includePost) {
        int mod = 0;
        if (this.statsPreModified != null) {
            for (PCLevelInfoStat stat : this.statsPreModified) {
                if (!stat.getStat().equals(aStat)) continue;
                mod += stat.getStatMod();
            }
        }
        if (includePost && this.statsPostModified != null) {
            for (PCLevelInfoStat stat : this.statsPostModified) {
                if (!stat.getStat().equals(aStat)) continue;
                mod += stat.getStatMod();
            }
        }
        return mod;
    }

    public void addModifiedStat(PCStat stat, int mod, boolean isPreMod) {
        List<PCLevelInfoStat> statList;
        if (isPreMod) {
            if (this.statsPreModified == null) {
                this.statsPreModified = new ArrayList<PCLevelInfoStat>();
            }
            statList = this.statsPreModified;
        } else {
            if (this.statsPostModified == null) {
                this.statsPostModified = new ArrayList<PCLevelInfoStat>();
            }
            statList = this.statsPostModified;
        }
        for (int i = 0; i < statList.size(); ++i) {
            PCLevelInfoStat aStat = statList.get(i);
            if (!stat.equals(aStat.getStat())) continue;
            aStat.modifyStat(mod);
            if (aStat.getStatMod() == 0) {
                statList.remove(aStat);
            }
            return;
        }
        statList.add(new PCLevelInfoStat(stat, mod));
    }

    private int getBonusSkillPool(PlayerCharacter aPC) {
        int returnValue = 0;
        PCClass aClass = aPC.getClassKeyed(this.classKeyName);
        String purchaseName = SettingsHandler.getGame().getPurchaseModeMethodName();
        if (purchaseName != null) {
            PointBuyMethod pbm = SettingsHandler.getGame().getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PointBuyMethod.class, purchaseName);
            List<BonusObj> bonusList = BonusUtilities.getBonusFromList(pbm.getBonuses(), "SKILLPOOL", "NUMBER");
            returnValue += (int)aPC.calcBonusFromList(bonusList, null);
        }
        if (aClass != null) {
            returnValue += (int)aClass.getBonusTo("SKILLPOOL", "NUMBER", this.classLevel, aPC);
            returnValue -= (int)aClass.getBonusTo("SKILLPOOL", "NUMBER", this.classLevel - 1, aPC);
        }
        if (this.classLevel == 1) {
            returnValue += (int)aPC.getTotalBonusTo("SKILLPOOL", "CLASS." + this.classKeyName);
        }
        returnValue += (int)aPC.getTotalBonusTo("SKILLPOOL", "CLASS." + this.classKeyName + ";LEVEL." + Integer.toString(this.classLevel));
        return returnValue += (int)aPC.getTotalBonusTo("SKILLPOOL", "LEVEL." + aPC.getCharacterLevel(this));
    }

    public PCLevelInfo clone() {
        PCLevelInfo clone = new PCLevelInfo(this.classKeyName);
        if (this.statsPostModified != null) {
            for (PCLevelInfoStat stat : this.statsPostModified) {
                if (clone.statsPostModified == null) {
                    clone.statsPostModified = new ArrayList<PCLevelInfoStat>();
                }
                clone.statsPostModified.add(stat);
            }
        }
        if (this.statsPreModified != null) {
            for (PCLevelInfoStat stat : this.statsPreModified) {
                if (clone.statsPreModified == null) {
                    clone.statsPreModified = new ArrayList<PCLevelInfoStat>();
                }
                clone.statsPreModified.add(stat);
            }
        }
        clone.classLevel = this.classLevel;
        clone.skillPointsGained = this.skillPointsGained;
        clone.skillPointsRemaining = this.skillPointsRemaining;
        return clone;
    }

    public void setFixedSkillPointsGained(int arg) {
        this.skillPointsGained = arg;
    }

    public int hashCode() {
        return this.classLevel * 17 + this.classKeyName.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PCLevelInfo) {
            PCLevelInfo other = (PCLevelInfo)o;
            return this.classLevel == other.classLevel && this.skillPointsGained == other.skillPointsGained && this.skillPointsRemaining == other.skillPointsRemaining && this.classKeyName.equals(other.classKeyName) && ObjectUtil.compareWithNull(this.statsPreModified, other.statsPreModified) && ObjectUtil.compareWithNull(this.statsPreModified, other.statsPreModified);
        }
        return false;
    }
}

