/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.system;

import java.math.BigDecimal;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.SizeAdjustment;
import pcgen.util.Logging;

public class LoadInfo
implements Loadable {
    private URI sourceURI;
    private String loadInfoName;
    private Map<CDOMSingleRef<SizeAdjustment>, BigDecimal> rawSizeMultiplierMap = new HashMap<CDOMSingleRef<SizeAdjustment>, BigDecimal>();
    private Map<SizeAdjustment, BigDecimal> sizeMultiplierMap = new HashMap<SizeAdjustment, BigDecimal>();
    private SortedMap<Integer, BigDecimal> strengthLoadMap = new TreeMap<Integer, BigDecimal>();
    private int minStrenghScoreWithLoad = 0;
    private int maxStrengthScoreWithLoad = 0;
    private BigDecimal loadScoreMultiplier = BigDecimal.ZERO;
    private int loadMultStep = 10;
    private Map<String, LoadMapEntry> loadMultiplierMap = new HashMap<String, LoadMapEntry>();
    private String modifyFormula;

    @Override
    public URI getSourceURI() {
        return this.sourceURI;
    }

    @Override
    public void setSourceURI(URI source) {
        this.sourceURI = source;
    }

    public void setLoadScoreMultiplier(BigDecimal multiplier) {
        this.loadScoreMultiplier = multiplier;
    }

    public BigDecimal getLoadScoreMultiplier() {
        return this.loadScoreMultiplier;
    }

    public void addLoadScoreValue(int score, BigDecimal load) {
        this.strengthLoadMap.put(score, load);
        if (score > this.maxStrengthScoreWithLoad) {
            this.maxStrengthScoreWithLoad = score;
        }
        if (score < this.minStrenghScoreWithLoad) {
            this.minStrenghScoreWithLoad = score;
        }
    }

    public BigDecimal getLoadScoreValue(int score) {
        if (score < this.minStrenghScoreWithLoad) {
            return BigDecimal.ZERO;
        }
        if (score > this.maxStrengthScoreWithLoad) {
            if (this.getLoadMultiplierCount() == 1) {
                return this.getLoadScoreValue(this.minStrenghScoreWithLoad);
            }
            return this.loadScoreMultiplier.multiply(this.getLoadScoreValue(score - this.loadMultStep));
        }
        BigDecimal loadScore = (BigDecimal)this.strengthLoadMap.get(score);
        if (loadScore == null) {
            SortedMap<Integer, BigDecimal> headMap = this.strengthLoadMap.headMap(score);
            return (BigDecimal)this.strengthLoadMap.get(headMap.lastKey());
        }
        return loadScore;
    }

    public void addSizeAdjustment(CDOMSingleRef<SizeAdjustment> size, BigDecimal multiplier) {
        this.rawSizeMultiplierMap.put(size, multiplier);
    }

    public void resolveSizeAdjustmentMap() {
        for (Map.Entry<CDOMSingleRef<SizeAdjustment>, BigDecimal> me : this.rawSizeMultiplierMap.entrySet()) {
            this.sizeMultiplierMap.put(me.getKey().resolvesTo(), me.getValue());
        }
    }

    public BigDecimal getSizeAdjustment(SizeAdjustment size) {
        if (this.sizeMultiplierMap.containsKey(size)) {
            return this.sizeMultiplierMap.get(size);
        }
        if (Logging.isDebugMode()) {
            Logging.debugPrint("Unable to find Load Multiplier for Size: " + size.getKeyName());
        }
        return BigDecimal.ONE;
    }

    public void addLoadMultiplier(String encumbranceType, Float value, String formula, Integer checkPenalty) {
        LoadMapEntry newEntry = new LoadMapEntry(value, formula, checkPenalty);
        this.loadMultiplierMap.put(encumbranceType, newEntry);
    }

    public Float getLoadMultiplier(String encumbranceType) {
        if (this.loadMultiplierMap.containsKey(encumbranceType)) {
            return this.loadMultiplierMap.get(encumbranceType).getMuliplier();
        }
        return null;
    }

    public String getLoadMoveFormula(String encumbranceType) {
        if (this.loadMultiplierMap.containsKey(encumbranceType)) {
            return this.loadMultiplierMap.get(encumbranceType).getFormula();
        }
        return "";
    }

    public int getLoadCheckPenalty(String encumbranceType) {
        if (this.loadMultiplierMap.containsKey(encumbranceType)) {
            return this.loadMultiplierMap.get(encumbranceType).getCheckPenalty();
        }
        return 0;
    }

    public void setLoadModifierFormula(String argFormula) {
        this.modifyFormula = argFormula;
    }

    public String getLoadModifierFormula() {
        return this.modifyFormula;
    }

    public int getLoadMultiplierCount() {
        return this.loadMultiplierMap.size();
    }

    public void setLoadMultStep(int step) {
        this.loadMultStep = step;
    }

    @Override
    public String getDisplayName() {
        return this.loadInfoName;
    }

    @Override
    public String getKeyName() {
        return this.getDisplayName();
    }

    @Override
    public String getLSTformat() {
        return this.getDisplayName();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isType(String type) {
        return false;
    }

    @Override
    public void setName(String name) {
        this.loadInfoName = name;
    }

    private static class LoadMapEntry {
        private Float multiplier;
        private String moveFormula;
        private Integer checkPenalty;

        public LoadMapEntry(Float argMultiplier, String argFormula, Integer argPenalty) {
            this.multiplier = argMultiplier;
            this.moveFormula = argFormula;
            this.checkPenalty = argPenalty;
        }

        public Float getMuliplier() {
            return this.multiplier;
        }

        public String getFormula() {
            return this.moveFormula;
        }

        public int getCheckPenalty() {
            return this.checkPenalty;
        }
    }
}

