/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.apache.commons.lang.SystemUtils;
import pcgen.system.ConfigurationSettings;

public class OptionsPathDialog
extends JDialog {
    private final JTextField dirField = new JTextField();
    private final JButton dirButton = new JButton();
    private String selectedDir = ConfigurationSettings.getDefaultSettingsFilesPath();

    public OptionsPathDialog(JFrame frame) {
        super((Frame)frame, true);
        this.initComponents();
    }

    public static String promptSettingsPath() {
        JFrame tempFrame = new JFrame("Select Settings Path");
        tempFrame.setLocationRelativeTo(null);
        OptionsPathDialog dialog = new OptionsPathDialog(tempFrame);
        tempFrame.setVisible(true);
        dialog.setVisible(true);
        tempFrame.setVisible(false);
        tempFrame.dispose();
        return dialog.getSelectedDirectory();
    }

    private void initComponents() {
        this.setResizable(false);
        this.setTitle("Directory for options.ini location");
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel label = new JLabel("Select a directory to store PCGen options in:");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)label, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)new JSeparator(), gridBagConstraints);
        label = new JLabel("If you have an existing options.ini file,then select the directory containing that file");
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)label, gridBagConstraints);
        ActionHandler handler = new ActionHandler();
        ButtonGroup group = new ButtonGroup();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.addRadioButton("<html><b>PCGen Dir</b>: This is the directory that PCGen is installed into", ConfigurationSettings.SettingsFilesPath.pcgen.name(), group, handler, gridBagConstraints);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.addRadioButton("<html><b>Mac User Dir</b>", ConfigurationSettings.SettingsFilesPath.mac_user.name(), group, handler, gridBagConstraints);
        } else if (SystemUtils.IS_OS_UNIX) {
            this.addRadioButton("<html><b>Freedesktop configuration sub-directory</b> Use for most Linux/BSD", ConfigurationSettings.SettingsFilesPath.FD_USER.name(), group, handler, gridBagConstraints);
        }
        this.addRadioButton("<html><b>Home Dir</b>: This is your home directory", ConfigurationSettings.SettingsFilesPath.user.name(), group, handler, gridBagConstraints);
        this.addRadioButton("Select a directory to use", "select", group, handler, gridBagConstraints);
        this.dirField.setText(ConfigurationSettings.getSettingsDirFromFilePath(this.selectedDir));
        this.dirField.setEditable(false);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.dirField, gridBagConstraints);
        this.dirButton.setText("...");
        this.dirButton.setEnabled(false);
        this.dirButton.addActionListener(handler);
        this.dirButton.setActionCommand("custom");
        this.dirButton.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.getContentPane().add((Component)this.dirButton, gridBagConstraints);
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(new Dimension(75, 23));
        okButton.setActionCommand("ok");
        okButton.addActionListener(handler);
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)okButton, gridBagConstraints);
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public String getSelectedDirectory() {
        return this.selectedDir;
    }

    private void addRadioButton(String text, String command, ButtonGroup group, ActionListener listener, GridBagConstraints gbc) {
        boolean selected = command.equals(this.selectedDir);
        if (selected) {
            text = text + " (default)";
        }
        JRadioButton rButton = new JRadioButton(text);
        rButton.setActionCommand(command);
        rButton.setSelected(selected);
        rButton.addActionListener(listener);
        group.add(rButton);
        this.getContentPane().add((Component)rButton, gbc);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("custom")) {
                JFileChooser fc = new JFileChooser(OptionsPathDialog.this.dirField.getText());
                fc.setFileSelectionMode(1);
                int rVal = fc.showOpenDialog(null);
                if (rVal == 0) {
                    int confirm;
                    File dir = fc.getSelectedFile();
                    if (dir.listFiles().length > 0 && (confirm = JOptionPane.showConfirmDialog(OptionsPathDialog.this.rootPane, "The folder " + dir.getAbsolutePath() + " is not empty.\n" + "All ini files in this directory may be overwritten. " + "Are you sure?")) != 0) {
                        return;
                    }
                    OptionsPathDialog.this.selectedDir = String.valueOf(fc.getSelectedFile());
                    OptionsPathDialog.this.dirField.setText(OptionsPathDialog.this.selectedDir);
                }
            } else if (command.equals("select")) {
                OptionsPathDialog.this.dirButton.setEnabled(true);
            } else if (command.equals("ok")) {
                OptionsPathDialog.this.dispose();
            } else {
                OptionsPathDialog.this.dirButton.setEnabled(false);
                OptionsPathDialog.this.selectedDir = command;
                OptionsPathDialog.this.dirField.setText(ConfigurationSettings.getSettingsDirFromFilePath(OptionsPathDialog.this.selectedDir));
            }
        }
    }
}

