/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.tools.Hyperactive;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.TipOfTheDayHandler;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.JLabelPane;
import pcgen.system.LanguageBundle;

public final class TipOfTheDay
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 6109389084434712217L;
    private static final UIPropertyContext propertyContext = UIPropertyContext.createContext("TipOfTheDay");
    private static final String NEXT = "next";
    private static final String PREV = "prev";
    private static final String HTML_START = "<html><body style=\"margin-left: 5px;margin-right: 5px;margin-top: 5px\">";
    private static final String HTML_END = "</body></html>";
    private JCheckBox chkShowTips;
    private JLabelPane tipText;
    private final TipOfTheDayHandler tipHandler;

    public TipOfTheDay(PCGenFrame frame) {
        super((Frame)frame, true);
        this.setTitle(LanguageBundle.getString("in_tod_title"));
        this.initUI();
        this.tipHandler = TipOfTheDayHandler.getInstance();
        this.tipHandler.loadTips();
        this.pack();
        Utility.installEscapeCloseOperation(this);
        this.showNextTip();
    }

    public static boolean showTipOfTheDay() {
        return propertyContext.getBoolean("showTipOfTheDay", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (NEXT.equals(e.getActionCommand())) {
            this.showNextTip();
            return;
        }
        if (PREV.equals(e.getActionCommand())) {
            this.showPrevTip();
            return;
        }
        this.quit();
    }

    private boolean hasTips() {
        return this.tipHandler.hasTips();
    }

    private void initUI() {
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        ImageIcon icon = Icons.TipOfTheDay24.getImageIcon();
        JLabel iconLabel = icon != null ? new JLabel(icon) : new JLabel("TipOfTheDay24.gif");
        iconLabel.setOpaque(true);
        panel.add((Component)iconLabel, "West");
        JLabel lblDidYouKnow = new JLabel("    " + LanguageBundle.getString("in_tod_didyouknow"));
        FontManipulation.xxlarge(lblDidYouKnow);
        lblDidYouKnow.setOpaque(true);
        this.tipText = new JLabelPane();
        this.tipText.setBorder(null);
        this.tipText.setFocusable(false);
        this.tipText.addHyperlinkListener(new Hyperactive());
        JScrollPane pane = new JScrollPane(this.tipText);
        pane.setBorder(null);
        JPanel content = new JPanel(new BorderLayout(0, 2));
        content.add((Component)lblDidYouKnow, "North");
        content.add((Component)pane, "Center");
        content.setPreferredSize(new Dimension(585, 230));
        panel.add((Component)content, "Center");
        this.chkShowTips = new JCheckBox(LanguageBundle.getString("in_tod_showTips"), propertyContext.initBoolean("showTipOfTheDay", true));
        JButton btnClose = new JButton(LanguageBundle.getString("in_close"));
        btnClose.setMnemonic(LanguageBundle.getMnemonic("in_mn_close"));
        btnClose.addActionListener(this);
        JButton btnPrevTip = new JButton(LanguageBundle.getString("in_tod_prevTip"));
        btnPrevTip.setMnemonic(LanguageBundle.getMnemonic("in_mn_tod_prevTip"));
        btnPrevTip.addActionListener(this);
        btnPrevTip.setActionCommand(PREV);
        JButton btnNextTip = new JButton(LanguageBundle.getString("in_tod_nextTip"));
        btnNextTip.setMnemonic(LanguageBundle.getMnemonic("in_mn_tod_nextTip"));
        btnNextTip.addActionListener(this);
        btnNextTip.setActionCommand(NEXT);
        JPanel actions = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0);
        actions.add((Component)this.chkShowTips, c);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(btnPrevTip);
        buttons.add(btnNextTip);
        buttons.add(btnClose);
        c.gridx = 1;
        c.anchor = 13;
        actions.add((Component)buttons, c);
        panel.add((Component)actions, "South");
        this.setContentPane(panel);
        this.getRootPane().setDefaultButton(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TipOfTheDay.this.quit();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TipOfTheDay.this.quit();
                }
            }
        });
    }

    private void quit() {
        this.setVisible(false);
        propertyContext.setBoolean("showTipOfTheDay", this.chkShowTips.isSelected());
        this.dispose();
    }

    private void showNextTip() {
        if (this.hasTips()) {
            this.showTip(this.tipHandler.getNextTip());
        }
    }

    private void showPrevTip() {
        if (this.hasTips()) {
            this.showTip(this.tipHandler.getPrevTip());
        }
    }

    private void showTip(String tip) {
        try {
            this.tipText.setText(HTML_START + LanguageBundle.getFormattedString("in_tod_tipDisplay", Integer.toString(this.tipHandler.getLastNumber() + 1), tip) + HTML_END);
            this.repaint();
        }
        catch (Exception exc) {
            exc.printStackTrace(System.err);
        }
    }
}

