/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util.treetable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import pcgen.gui2.util.treetable.TreeTableNode;

public class DefaultTreeTableNode
extends DefaultMutableTreeNode
implements TreeTableNode {
    private List<Object> data;

    public DefaultTreeTableNode() {
        this(Collections.emptyList());
    }

    public DefaultTreeTableNode(List<?> data) {
        this.setValues(data);
    }

    public DefaultTreeTableNode(TreeNode node) {
        this();
        if (node instanceof TreeTableNode) {
            TreeTableNode treeTableNode = (TreeTableNode)node;
            this.setValues(treeTableNode.getValues());
        }
        for (int x = 0; x < node.getChildCount(); ++x) {
            this.add(new DefaultTreeTableNode(node.getChildAt(x)));
        }
    }

    @Override
    public Object getValueAt(int column) {
        if (this.data.size() > column) {
            return this.data.get(column);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int column) {
        if (this.data.isEmpty()) {
            this.data = new ArrayList<Object>(column + 1);
        }
        while (this.data.size() <= column) {
            this.data.add(null);
        }
        this.data.set(column, value);
    }

    @Override
    public List<Object> getValues() {
        return this.data;
    }

    protected void setValues(List<?> values) {
        this.data = new ArrayList(values);
    }

    @Override
    public String toString() {
        Object name;
        if (!this.data.isEmpty() && (name = this.data.get(0)) != null) {
            return name.toString();
        }
        return super.toString();
    }
}

