/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.facade.core.InfoFacade;
import pcgen.gui2.util.treetable.TreeTableNode;
import pcgen.util.SortKeyAware;

public final class Comparators {
    private static final ToStringComparator tSC = new ToStringComparator();
    private static final ToStringIgnoreCaseComparator tSICC = new ToStringIgnoreCaseComparator();
    private static final ToStringIgnoreCaseCollator tSICCol = new ToStringIgnoreCaseCollator();
    private static final IntegerComparator iC = new IntegerComparator();
    private static final NumberComparator nC = new NumberComparator();
    private static final DateComparator dC = new DateComparator();
    private static final HashCodeComparator hCC = new HashCodeComparator();
    private static final TreeTableNodeComparator treeNodeComp = new TreeTableNodeComparator();

    private Comparators() {
    }

    public static Comparator<Object> toStringComparator() {
        return tSC;
    }

    public static Comparator<Object> toStringIgnoreCaseComparator() {
        return tSICC;
    }

    public static Comparator<Object> toStringIgnoreCaseCollator() {
        return tSICCol;
    }

    public static Comparator<Object> treeTableNodeComparator() {
        return treeNodeComp;
    }

    public static <T> Comparator<T> inverseComparator(Comparator<T> comparator) {
        if (comparator instanceof InverseComparator) {
            return ((InverseComparator)comparator).getComparator();
        }
        return new InverseComparator<T>(comparator);
    }

    public static Comparator<Object> hashCodeComparator() {
        return hCC;
    }

    public static Comparator<Integer> integerComparator() {
        return iC;
    }

    public static Comparator<Number> numberComparator() {
        return nC;
    }

    public static Comparator<Date> dateComparator() {
        return dC;
    }

    public static Comparator<String> ignoreCaseStringComparator() {
        return String.CASE_INSENSITIVE_ORDER;
    }

    public static <T> Comparator<? super T> getComparatorFor(Class<T> c) {
        if (c == Integer.class) {
            return Comparators.integerComparator();
        }
        if (c.getSuperclass() == Number.class) {
            return Comparators.numberComparator();
        }
        if (c == Date.class) {
            return Comparators.dateComparator();
        }
        if (c == String.class) {
            return Comparators.ignoreCaseStringComparator();
        }
        if (c == TreeTableNode.class || c == InfoFacade.class || c.getSuperclass() == InfoFacade.class) {
            return Comparators.treeTableNodeComparator();
        }
        return Comparators.toStringComparator();
    }

    private static final class InverseComparator<E>
    implements Comparator<E>,
    Serializable {
        private final Comparator<E> comparator;

        public InverseComparator(Comparator<E> comparator) {
            this.comparator = comparator;
        }

        public Comparator<E> getComparator() {
            return this.comparator;
        }

        @Override
        public int compare(E o1, E o2) {
            return -this.comparator.compare(o1, o2);
        }
    }

    private static final class HashCodeComparator
    implements Comparator<Object> {
        private HashCodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return iC.compare(o1.hashCode(), o2.hashCode());
        }
    }

    private static final class DateComparator
    implements Comparator<Date> {
        private DateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            long n2;
            long n1 = o1.getTime();
            if (n1 < (n2 = o2.getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
    }

    private static final class NumberComparator
    implements Comparator<Number> {
        private NumberComparator() {
        }

        @Override
        public int compare(Number o1, Number o2) {
            double d2;
            double d1 = o1.doubleValue();
            if (d1 < (d2 = o2.doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    private static final class IntegerComparator
    implements Comparator<Integer> {
        private IntegerComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    }

    private static final class ToStringIgnoreCaseCollator
    implements Comparator<Object>,
    Serializable {
        private static final Collator collator = Collator.getInstance();

        private ToStringIgnoreCaseCollator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = o1 == null ? "" : o1.toString();
            String s2 = o2 == null ? "" : o2.toString();
            return collator.compare(s1, s2);
        }
    }

    private static final class TreeTableNodeComparator
    implements Comparator<Object>,
    Serializable {
        private TreeTableNodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String key1 = this.getSortKey(o1);
            String key2 = this.getSortKey(o2);
            Collator collator = Collator.getInstance();
            if (!key1.equals(key2)) {
                return collator.compare(key1, key2);
            }
            return collator.compare(String.valueOf(o1), String.valueOf(o2));
        }

        private String getSortKey(Object obj1) {
            String key;
            if (obj1 == null) {
                key = "";
            } else if (obj1 instanceof CDOMObject) {
                CDOMObject co = (CDOMObject)obj1;
                key = co.get(StringKey.SORT_KEY);
                if (key == null) {
                    key = co.getDisplayName();
                }
            } else {
                key = obj1 instanceof SortKeyAware ? ((SortKeyAware)obj1).getSortKey() : obj1.toString();
            }
            return key;
        }
    }

    private static final class ToStringIgnoreCaseComparator
    implements Comparator<Object>,
    Serializable {
        private ToStringIgnoreCaseComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return (o1 == null ? "" : o1.toString()).compareToIgnoreCase(o2 == null ? "" : o2.toString());
        }
    }

    private static final class ToStringComparator
    implements Comparator<Object>,
    Serializable {
        private ToStringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return (o1 == null ? "" : o1.toString()).compareTo(o2 == null ? "" : o2.toString());
        }
    }
}

