/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import pcgen.util.PJEP;

public class PjepPool {
    private Stack<PJEP> freeStack = new Stack();
    private List<PJEP> usedList = new ArrayList<PJEP>();
    private static PjepPool instance = new PjepPool();

    private PjepPool() {
    }

    public static PjepPool getInstance() {
        return instance;
    }

    public synchronized void initialise() {
        this.freeStack.push(new PJEP());
    }

    public synchronized PJEP aquire() {
        return this.aquire(null, "");
    }

    public synchronized PJEP aquire(Object parent, String variableSource) {
        PJEP jep = this.freeStack.size() > 0 ? this.freeStack.pop() : new PJEP();
        this.usedList.add(jep);
        jep.initSymTab();
        jep.setVariableSource(variableSource);
        jep.setParent(parent);
        return jep;
    }

    public synchronized void release(PJEP interp) {
        if (this.usedList.contains((Object)interp)) {
            this.usedList.remove((Object)interp);
        } else {
            System.err.println("Tried to release a PJEP instance that we did not aquire...");
        }
        interp.setParent(null);
        this.freeStack.push(interp);
    }

    public synchronized void dumpStats() {
        System.out.println("PJEP Pool: ");
        System.out.println("    Currently Unused: " + this.freeStack.size());
        System.out.println("    Currently Used  : " + this.usedList.size());
    }
}

