/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class TempValueLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    @Override
    public String getTokenName() {
        return "TEMPVALUE";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " must have three | delimited arguments : " + value, context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        if (tok.countTokens() != 3) {
            return new ParseResult.Fail(this.getTokenName() + " requires three arguments, MIN=, MAX= and TITLE= : " + value, context);
        }
        if (!tok.nextToken().startsWith("MIN=")) {
            return new ParseResult.Fail(this.getTokenName() + " first argument was not MIN=", context);
        }
        if (!tok.nextToken().startsWith("MAX=")) {
            return new ParseResult.Fail(this.getTokenName() + " second argument was not MAX=", context);
        }
        if (!tok.nextToken().startsWith("TITLE=")) {
            return new ParseResult.Fail(this.getTokenName() + " third argument was not TITLE=", context);
        }
        StringBuilder sb = new StringBuilder(value.length() + 20);
        sb.append(value);
        context.getObjectContext().put(obj, StringKey.TEMPVALUE, sb.toString());
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject cdo) {
        String tv = context.getObjectContext().getString(cdo, StringKey.TEMPVALUE);
        if (tv == null) {
            return null;
        }
        return new String[]{tv};
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

