/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.companionmod;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.core.PCClass;
import pcgen.core.SubClass;
import pcgen.core.character.CompanionMod;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class FollowerToken
extends AbstractTokenWithSeparator<CompanionMod>
implements CDOMPrimaryToken<CompanionMod> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    private static final Class<SubClass> SUBCLASS_CLASS = SubClass.class;

    @Override
    public String getTokenName() {
        return "FOLLOWER";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CompanionMod cMod, String value) {
        int equalLoc = value.indexOf(61);
        if (equalLoc == -1) {
            return new ParseResult.Fail("No = in token.", context);
        }
        if (equalLoc != value.lastIndexOf(61)) {
            return new ParseResult.Fail("Too many = in token.", context);
        }
        String classString = value.substring(0, equalLoc);
        String levelString = value.substring(equalLoc + 1);
        Integer lvl = Integer.valueOf(levelString);
        context.getObjectContext().put((CDOMObject)cMod, IntegerKey.LEVEL, lvl);
        StringTokenizer bTok = new StringTokenizer(classString, ",");
        while (bTok.hasMoreTokens()) {
            String classKey = bTok.nextToken();
            PCClass pcClass = context.getReferenceContext().silentlyGetConstructedCDOMObject(PCCLASS_CLASS, classKey);
            if (pcClass != null) {
                CDOMSingleRef<PCClass> pcc = context.getReferenceContext().getCDOMReference(PCCLASS_CLASS, classKey);
                context.getObjectContext().put(cMod, MapKey.APPLIED_CLASS, pcc, lvl);
                continue;
            }
            context.getObjectContext().put(cMod, MapKey.APPLIED_VARIABLE, classKey, lvl);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CompanionMod cMod) {
        MapChanges<CDOMSingleRef<? extends PCClass>, Integer> changes = context.getObjectContext().getMapChanges(cMod, MapKey.APPLIED_CLASS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        Map<CDOMSingleRef<? extends PCClass>, Integer> map = changes.getAdded();
        for (Map.Entry<CDOMSingleRef<? extends PCClass>, Integer> me : map.entrySet()) {
            CDOMSingleRef<? extends PCClass> ref = me.getKey();
            Class refClass = ref.getReferenceClass();
            if (SUBCLASS_CLASS.equals(refClass)) {
                Category parent = ((CategorizedCDOMReference)((Object)ref)).getCDOMCategory();
                set.add(parent.toString() + "." + ref.getLSTformat(false) + '=' + me.getValue());
                continue;
            }
            set.add(ref.getLSTformat(false) + '=' + me.getValue());
        }
        return new String[]{StringUtil.join(set, (String)"|")};
    }

    @Override
    public Class<CompanionMod> getTokenClass() {
        return CompanionMod.class;
    }
}

