/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreAlignParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    @Override
    public String[] kindsHandled() {
        return new String[]{"align"};
    }

    @Override
    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        String[] alignments = formula.split(",");
        GameMode gm = SettingsHandler.getGame();
        if (gm == null) {
            prereq.setKey("");
            prereq.setOperator(PrerequisiteOperator.EQ);
            return prereq;
        }
        if (Globals.getContext().getReferenceContext().getConstructedObjectCount(PCAlignment.class) == 0) {
            prereq.setKey("");
            prereq.setOperator(PrerequisiteOperator.EQ);
        } else if (alignments.length == 1) {
            prereq.setKey(formula);
            prereq.setOperator(PrerequisiteOperator.EQ);
        } else {
            prereq.setKind(null);
            prereq.setOperator(PrerequisiteOperator.GTEQ);
            prereq.setOperand("1");
            for (int i = 0; i < alignments.length; ++i) {
                Prerequisite subreq = new Prerequisite();
                subreq.setKind("align");
                subreq.setKey(alignments[i]);
                subreq.setOperator(PrerequisiteOperator.EQ);
                prereq.addPrerequisite(subreq);
            }
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }
}

