/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Movement;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MoveLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "MOVE";
    }

    private ParseResult validateMove(String value, String mod) {
        try {
            if (Integer.parseInt(mod) < 0) {
                return new ParseResult.Fail("Invalid movement (cannot be negative): " + mod + " in MOVE: " + value);
            }
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Invalid movement (must be an integer >= 0): " + mod + " in MOVE: " + value);
        }
        return ParseResult.SUCCESS;
    }

    protected char separator() {
        return ',';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        Movement cm;
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        StringTokenizer moves = new StringTokenizer(value, ",");
        if (moves.countTokens() == 1) {
            cm = new Movement(1);
            String mod = moves.nextToken();
            ParseResult pr = this.validateMove(value, mod);
            if (!pr.passed()) {
                return pr;
            }
            cm.assignMovement(0, "Walk", mod);
        } else {
            cm = new Movement(moves.countTokens() / 2);
            int x = 0;
            while (moves.countTokens() > 1) {
                String type = moves.nextToken();
                String mod = moves.nextToken();
                ParseResult pr = this.validateMove(value, mod);
                if (!pr.passed()) {
                    return pr;
                }
                cm.assignMovement(x++, type, mod);
            }
            if (moves.countTokens() != 0) {
                return new ParseResult.Fail("Badly formed MOVE token (extra value at end of list): " + value, context);
            }
        }
        cm.setMoveRatesFlag(0);
        context.getObjectContext().addToList(obj, ListKey.MOVEMENT, (Object)cm);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.MOVEMENT);
        Collection added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (Movement m : added) {
            if (m.getMoveRatesFlag() != 0) continue;
            StringBuilder sb = new StringBuilder();
            m.addTokenContents(sb);
            set.add(sb.toString());
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

