/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCStat;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class StatToken
extends AbstractNonEmptyToken<Spell>
implements CDOMPrimaryToken<Spell> {
    private static final Class<PCStat> PCSTAT_CLASS = PCStat.class;

    public String getTokenName() {
        return "STAT";
    }

    public ParseResult parseNonEmptyToken(LoadContext context, Spell spell, String value) {
        CDOMSingleRef pcs = context.getReferenceContext().getCDOMReference(PCSTAT_CLASS, value);
        if (pcs == null) {
            return new ParseResult.Fail("Invalid Stat Abbreviation in Token " + this.getTokenName() + ": " + value, context);
        }
        context.getObjectContext().put((CDOMObject)spell, ObjectKey.SPELL_STAT, (Object)pcs);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Spell spell) {
        CDOMSingleRef pcs = (CDOMSingleRef)context.getObjectContext().getObject((CDOMObject)spell, ObjectKey.SPELL_STAT);
        if (pcs == null) {
            return null;
        }
        return new String[]{pcs.getLSTformat(false)};
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

