/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Campaign;
import pcgen.persistence.lst.InstallLstToken;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class SourcedateLst
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMPrimaryToken<CDOMObject>,
InstallLstToken {
    public String getTokenName() {
        return "SOURCEDATE";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        Date theDate = SourcedateLst.getDate(value);
        if (theDate == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        context.getObjectContext().put(obj, ObjectKey.SOURCE_DATE, (Object)theDate);
        return ParseResult.SUCCESS;
    }

    private static Date getDate(String value) {
        Date theDate;
        DateFormat df = new SimpleDateFormat("yyyy-MM");
        try {
            theDate = df.parse(value);
        }
        catch (ParseException pe) {
            df = DateFormat.getDateInstance();
            try {
                theDate = df.parse(value);
            }
            catch (ParseException e) {
                SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
                try {
                    theDate = formatter.parse(value);
                }
                catch (ParseException ipe) {
                    Logging.log((Level)Logging.LST_ERROR, (String)"Error parsing date", (Throwable)ipe);
                    return null;
                }
            }
        }
        return theDate;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Date date = (Date)context.getObjectContext().getObject(obj, ObjectKey.SOURCE_DATE);
        if (date == null) {
            return null;
        }
        DateFormat df = DateFormat.getDateInstance(1);
        return new String[]{df.format(date)};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public boolean parse(Campaign campaign, String value, URI sourceURI) {
        Date theDate = SourcedateLst.getDate(value);
        if (theDate == null) {
            return false;
        }
        campaign.put(ObjectKey.SOURCE_DATE, (Object)theDate);
        return true;
    }
}

