/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Equipment;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class PreClassTester
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, Equipment equipment, PlayerCharacter aPC) {
        Logging.debugPrint((String)("PreClass on equipment: " + equipment.getName() + "  pre: " + this.toHtmlString(prereq)));
        if (aPC == null) {
            return 0;
        }
        return this.passes(prereq, aPC, (CDOMObject)equipment);
    }

    public int passes(Prerequisite prereq, PlayerCharacter character, CDOMObject source) {
        int preClass;
        int countedTotal;
        int runningTotal;
        block31: {
            CharacterDisplay display = character.getDisplay();
            runningTotal = 0;
            countedTotal = 0;
            boolean sumLevels = prereq.isTotalValues();
            String aString = prereq.getKey().toUpperCase();
            preClass = Integer.parseInt(prereq.getOperand());
            if ("SPELLCASTER".equals(aString)) {
                int spellCaster = character.isSpellCaster(preClass, sumLevels);
                if (spellCaster > 0) {
                    if (prereq.isCountMultiples()) {
                        countedTotal = spellCaster;
                    } else {
                        runningTotal = preClass;
                    }
                }
            } else if (aString.startsWith("SPELLCASTER.")) {
                int spellCaster = character.isSpellCaster(aString.substring(12), preClass, sumLevels);
                if (spellCaster > 0) {
                    if (prereq.isCountMultiples()) {
                        countedTotal = spellCaster;
                    } else {
                        runningTotal = preClass;
                    }
                }
            } else if (aString.equals("ANY")) {
                for (PCClass cl : display.getClassSet()) {
                    if (prereq.isCountMultiples()) {
                        if (display.getLevel(cl) < preClass) continue;
                        ++countedTotal;
                        continue;
                    }
                    runningTotal = Math.max(runningTotal, display.getLevel(cl));
                }
            } else if (aString.startsWith("TYPE=") || aString.startsWith("TYPE.")) {
                String typeString = aString.substring(5);
                for (PCClass cl : display.getClassSet()) {
                    if (cl.isType(typeString)) {
                        if (prereq.isCountMultiples()) {
                            if (display.getLevel(cl) < preClass) continue;
                            ++countedTotal;
                            continue;
                        }
                        runningTotal = Math.max(runningTotal, display.getLevel(cl));
                        continue;
                    }
                    block2: for (CDOMReference ref : cl.getSafeListFor(ListKey.SERVES_AS_CLASS)) {
                        for (PCClass fakeClass : ref.getContainedObjects()) {
                            if (!fakeClass.isType(typeString)) continue;
                            if (prereq.isCountMultiples()) {
                                if (display.getLevel(cl) < preClass) continue block2;
                                ++countedTotal;
                                continue block2;
                            }
                            runningTotal += display.getLevel(cl);
                            continue block2;
                        }
                    }
                }
            } else {
                PCClass aClass = character.getClassKeyed(aString);
                if (aClass != null) {
                    if (prereq.isCountMultiples()) {
                        if (display.getLevel(aClass) >= preClass) {
                            ++countedTotal;
                        }
                    } else {
                        runningTotal += display.getLevel(aClass);
                    }
                } else {
                    for (PCClass theClass : display.getClassSet()) {
                        for (CDOMReference ref : theClass.getSafeListFor(ListKey.SERVES_AS_CLASS)) {
                            for (PCClass fakeClass : ref.getContainedObjects()) {
                                if (!fakeClass.getKeyName().equalsIgnoreCase(aString)) continue;
                                if (prereq.isCountMultiples()) {
                                    if (display.getLevel(theClass) < preClass) break block31;
                                    ++countedTotal;
                                    break block31;
                                }
                                runningTotal += display.getLevel(theClass);
                                break block31;
                            }
                        }
                    }
                }
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, preClass);
        return this.countedTotal(prereq, prereq.isCountMultiples() ? countedTotal : runningTotal);
    }

    public String kindHandled() {
        return "CLASS";
    }

    public String toHtmlString(Prerequisite prereq) {
        String level = prereq.getOperand();
        String operator = prereq.getOperator().toDisplayString();
        return LanguageBundle.getFormattedString((String)"PreClass.toHtml", (Object[])new Object[]{prereq.getKey(), operator, level});
    }
}

