/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.ClassIdentity;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.NonInteractive;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.Domain;
import pcgen.core.EquipmentModifier;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.rules.persistence.token.PostDeferredToken;
import pcgen.util.Logging;

public class ChooseLst
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMPrimaryToken<CDOMObject>,
PostDeferredToken<CDOMObject> {
    public String getTokenName() {
        return "CHOOSE";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        String val;
        String key;
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (obj instanceof NonInteractive) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Non-Interactive object type: " + obj.getClass().getSimpleName(), context);
        }
        int pipeLoc = value.indexOf("|");
        if (value.startsWith("FEAT=")) {
            key = "FEATEQ";
            val = value.substring(5);
        } else if (value.startsWith("LANGAUTO:")) {
            key = "LANGAUTO";
            val = value.substring(9);
        } else if (pipeLoc == -1) {
            key = value;
            val = null;
        } else {
            key = value.substring(0, pipeLoc);
            val = value.substring(pipeLoc + 1);
        }
        if (!(obj instanceof Ability || obj instanceof Domain || obj instanceof Race || obj instanceof PCTemplate || obj instanceof Skill || obj instanceof EquipmentModifier || "NUMBER".equals(key))) {
            return new ParseResult.Fail(this.getTokenName() + " is not supported for " + obj.getClass().getSimpleName(), context);
        }
        if (key.startsWith("NUMCHOICES=")) {
            String maxCount = key.substring(11);
            if (maxCount == null || maxCount.length() == 0) {
                return new ParseResult.Fail("NUMCHOICES in CHOOSE must be a formula: " + value, context);
            }
            Formula f = FormulaFactory.getFormulaFor((String)maxCount);
            if (!f.isValid()) {
                return new ParseResult.Fail("Number of Choices in " + this.getTokenName() + " was not valid: " + f.toString(), context);
            }
            context.getObjectContext().put(obj, FormulaKey.NUMCHOICES, f);
            pipeLoc = val.indexOf("|");
            if (pipeLoc == -1) {
                key = val;
                val = null;
            } else {
                key = val.substring(0, pipeLoc);
                val = val.substring(pipeLoc + 1);
            }
        }
        return context.processSubToken((Object)obj, this.getTokenName(), key, val);
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        String[] str = context.unparseSubtoken((Object)obj, this.getTokenName());
        if (str == null) {
            return null;
        }
        Formula choices = context.getObjectContext().getFormula(obj, FormulaKey.NUMCHOICES);
        String choicesString = choices == null ? null : "NUMCHOICES=" + choices.toString() + "|";
        for (int i = 0; i < str.length; ++i) {
            if (str[i].endsWith("|")) {
                str[i] = str[i].substring(0, str[i].length() - 1);
            }
            if (choicesString != null) {
                str[i] = choicesString + str[i];
            }
            if (!str[i].startsWith("FEATEQ|")) continue;
            str[i] = "FEAT=" + str[i].substring(7);
        }
        return str;
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public Class<CDOMObject> getDeferredTokenClass() {
        return CDOMObject.class;
    }

    public boolean process(LoadContext context, CDOMObject obj) {
        ChooseInformation newChoose = (ChooseInformation)obj.get(ObjectKey.CHOOSE_INFO);
        String oldChoose = obj.get(StringKey.CHOICE_STRING);
        if (newChoose != null && oldChoose != null) {
            Logging.errorPrint((String)("New style CHOOSE and old style CHOOSE both found on " + obj.getClass().getSimpleName() + " " + obj.getKeyName()));
            return false;
        }
        if (newChoose != null) {
            ClassIdentity chooseClass = newChoose.getClassIdentity();
            List newactors = obj.getListFor(ListKey.NEW_CHOOSE_ACTOR);
            if (newactors != null) {
                for (ChooseSelectionActor csa : newactors) {
                    if (chooseClass.getChoiceClass().equals(csa.getChoiceClass())) continue;
                    Logging.errorPrint((String)("CHOOSE of type " + chooseClass.getName() + " on " + obj.getClass().getSimpleName() + " " + obj.getKeyName() + " had an actor from token " + csa.getSource() + " that was expecting a " + csa.getChoiceClass().getSimpleName()));
                    return false;
                }
            }
        }
        return true;
    }

    public int getPriority() {
        return 0;
    }
}

