/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesPanel;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.CombatHasBeenInitiatedMessage;
import gmgen.pluginmgr.messages.CombatantHasBeenUpdatedMessage;
import gmgen.pluginmgr.messages.RequestAddPreferencesPanelMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import pcgen.core.SettingsHandler;
import pcgen.gui2.tools.Utility;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.system.LanguageBundle;
import plugin.network.NetworkModel;
import plugin.network.gui.NetworkView;
import plugin.network.gui.PreferencesNetworkingPanel;

public class NetworkPlugin
implements InteractivePlugin {
    public static final String LOG_NAME = "Network";
    private static final String NAME = "Network";
    private static final String IN_NAME = "in_plugin_network_name";
    private static final String IN_NAME_MN = "in_mn_plugin_network_name";
    private String version = "01.00.99.01.00";
    private NetworkModel model;
    private JMenuItem netToolsItem = new JMenuItem();
    private PCGenMessageHandler messageHandler;

    public void start(PCGenMessageHandler mh) {
        this.messageHandler = mh;
        this.model = new NetworkModel();
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddTabToGMGenMessage((Object)this, this.getLocalizedName(), (Component)this.model.getView()));
        this.initMenus();
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddPreferencesPanelMessage((Object)this, this.getLocalizedName(), (PreferencesPanel)new PreferencesNetworkingPanel(this.model)));
    }

    public void stop() {
        this.messageHandler = null;
    }

    public int getPriority() {
        return SettingsHandler.getGMGenOption((String)"Network.LoadOrder", (int)60);
    }

    public String getPluginName() {
        return "Network";
    }

    private String getLocalizedName() {
        return LanguageBundle.getString((String)IN_NAME);
    }

    public void handleMessage(PCGenMessage message) {
        if (message instanceof CombatHasBeenInitiatedMessage) {
            this.handleCombatRequestMessage((CombatHasBeenInitiatedMessage)message);
        } else if (message instanceof FocusOrStateChangeOccurredMessage) {
            this.handleStateChangedMessage((FocusOrStateChangeOccurredMessage)message);
        } else if (message instanceof CombatantHasBeenUpdatedMessage) {
            this.handleCombatantUpdatedMessage((CombatantHasBeenUpdatedMessage)message);
        }
    }

    private void handleStateChangedMessage(FocusOrStateChangeOccurredMessage message) {
        if (this.isActive()) {
            this.netToolsItem.setEnabled(false);
            if (this.model.getCombat() == null) {
                this.messageHandler.handleMessage((PCGenMessage)new CombatHasBeenInitiatedMessage((Object)this));
            }
            try {
                GMGenSystemView.getTabPane().setIconAt(GMGenSystemView.getTabPane().indexOfTab(this.getLocalizedName()), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.model.clearIcon();
            this.model.refresh();
        } else {
            this.netToolsItem.setEnabled(true);
        }
    }

    private void handleCombatRequestMessage(CombatHasBeenInitiatedMessage message) {
        if (message.getSource() == this) {
            this.model.setCombat(message.getCombat());
        }
        this.model.refresh();
    }

    private void handleCombatantUpdatedMessage(CombatantHasBeenUpdatedMessage message) {
        this.model.combatantUpdated(message.getCombatant());
    }

    public boolean isActive() {
        JTabbedPane tp = Utility.getTabbedPaneFor((Component)this.model.getView());
        return tp != null && JOptionPane.getFrameForComponent(tp).isFocused() && tp.getSelectedComponent().equals(this.model.getView());
    }

    public void toolMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!(tp.getComponentAt(i) instanceof NetworkView)) continue;
            tp.setSelectedIndex(i);
        }
    }

    private void initMenus() {
        this.netToolsItem.setMnemonic(LanguageBundle.getMnemonic((String)IN_NAME_MN));
        this.netToolsItem.setText(this.getLocalizedName());
        this.netToolsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetworkPlugin.this.toolMenuItem(evt);
            }
        });
        this.messageHandler.handleMessage((PCGenMessage)new AddMenuItemToGMGenToolsMenuMessage((Object)this, this.netToolsItem));
    }

    public File getDataDirectory() {
        File dataDir = new File(SettingsHandler.getGmgenPluginDir(), this.getPluginName());
        return dataDir;
    }
}

