/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class ItemToken
extends AbstractTokenWithSeparator<Spell>
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "ITEM";
    }

    protected char separator() {
        return ',';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Spell spell, String value) {
        StringTokenizer aTok = new StringTokenizer(value, ",");
        while (aTok.hasMoreTokens()) {
            String tokString = aTok.nextToken();
            int bracketLoc = tokString.indexOf(91);
            if (bracketLoc == 0) {
                if (tokString.lastIndexOf(93) != tokString.length() - 1) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + ": mismatched open Bracket: " + tokString + " in " + value, context);
                }
                String substring = tokString.substring(1, tokString.length() - 1);
                if (substring.length() == 0) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + ": cannot be empty item in brackets []", context);
                }
                context.getObjectContext().addToList((CDOMObject)spell, ListKey.PROHIBITED_ITEM, (Object)Type.getConstant((String)substring));
                continue;
            }
            if (tokString.lastIndexOf(93) != -1) {
                return new ParseResult.Fail("Invalid " + this.getTokenName() + ": mismatched close Bracket: " + tokString + " in " + value, context);
            }
            context.getObjectContext().addToList((CDOMObject)spell, ListKey.ITEM, (Object)Type.getConstant((String)tokString));
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Spell spell) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)spell, ListKey.ITEM);
        Changes proChanges = context.getObjectContext().getListChanges((CDOMObject)spell, ListKey.PROHIBITED_ITEM);
        Collection changeAdded = changes.getAdded();
        Collection proAdded = proChanges.getAdded();
        StringBuilder sb = new StringBuilder();
        boolean needComma = false;
        if (changeAdded != null) {
            for (Type t : changeAdded) {
                if (needComma) {
                    sb.append(",");
                }
                sb.append(t.toString());
                needComma = true;
            }
        }
        if (proAdded != null) {
            for (Type t : proAdded) {
                if (needComma) {
                    sb.append(",");
                }
                sb.append('[').append(t.toString()).append(']');
                needComma = true;
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return new String[]{sb.toString()};
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

