/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.nodes;

import coursier.util.shaded.org.jsoup.SerializationException;
import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.Normalizer;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.Attribute;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.Range;
import coursier.util.shaded.org.jsoup.parser.ParseSettings;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class Attributes
implements Iterable<Attribute>,
Cloneable {
    static final char InternalPrefix = '/';
    protected static final String dataPrefix = "data-";
    private static final int InitialCapacity = 3;
    private static final int GrowthFactor = 2;
    static final int NotFound = -1;
    private static final String EmptyString = "";
    private int size = 0;
    @Nullable String[] keys = new String[3];
    @Nullable Object[] vals = new Object[3];

    private void checkCapacity(int minNewSize) {
        int newCap;
        Validate.isTrue(minNewSize >= this.size);
        int curCap = this.keys.length;
        if (curCap >= minNewSize) {
            return;
        }
        int n = newCap = curCap >= 3 ? this.size * 2 : 3;
        if (minNewSize > newCap) {
            newCap = minNewSize;
        }
        this.keys = Arrays.copyOf(this.keys, newCap);
        this.vals = Arrays.copyOf(this.vals, newCap);
    }

    int indexOfKey(String key2) {
        Validate.notNull(key2);
        for (int i = 0; i < this.size; ++i) {
            if (!key2.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOfKeyIgnoreCase(String key2) {
        Validate.notNull(key2);
        for (int i = 0; i < this.size; ++i) {
            if (!key2.equalsIgnoreCase(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    static String checkNotNull(@Nullable Object val) {
        return val == null ? EmptyString : (String)val;
    }

    public String get(String key2) {
        int i = this.indexOfKey(key2);
        return i == -1 ? EmptyString : Attributes.checkNotNull(this.vals[i]);
    }

    public @Nullable Attribute attribute(String key2) {
        int i = this.indexOfKey(key2);
        return i == -1 ? null : new Attribute(key2, Attributes.checkNotNull(this.vals[i]), this);
    }

    public String getIgnoreCase(String key2) {
        int i = this.indexOfKeyIgnoreCase(key2);
        return i == -1 ? EmptyString : Attributes.checkNotNull(this.vals[i]);
    }

    public Attributes add(String key2, @Nullable String value) {
        this.addObject(key2, value);
        return this;
    }

    private void addObject(String key2, @Nullable Object value) {
        this.checkCapacity(this.size + 1);
        this.keys[this.size] = key2;
        this.vals[this.size] = value;
        ++this.size;
    }

    public Attributes put(String key2, @Nullable String value) {
        Validate.notNull(key2);
        int i = this.indexOfKey(key2);
        if (i != -1) {
            this.vals[i] = value;
        } else {
            this.add(key2, value);
        }
        return this;
    }

    Map<String, Object> userData() {
        HashMap<String, Object> userData;
        int i = this.indexOfKey("/jsoup.userdata");
        if (i == -1) {
            userData = new HashMap();
            this.addObject("/jsoup.userdata", userData);
        } else {
            userData = (Map)this.vals[i];
        }
        assert (userData != null);
        return userData;
    }

    public @Nullable Object userData(String key2) {
        Validate.notNull(key2);
        if (!this.hasKey("/jsoup.userdata")) {
            return null;
        }
        Map<String, Object> userData = this.userData();
        return userData.get(key2);
    }

    public Attributes userData(String key2, Object value) {
        Validate.notNull(key2);
        this.userData().put(key2, value);
        return this;
    }

    void putIgnoreCase(String key2, @Nullable String value) {
        int i = this.indexOfKeyIgnoreCase(key2);
        if (i != -1) {
            this.vals[i] = value;
            String old = this.keys[i];
            assert (old != null);
            if (!old.equals(key2)) {
                this.keys[i] = key2;
            }
        } else {
            this.add(key2, value);
        }
    }

    public Attributes put(String key2, boolean value) {
        if (value) {
            this.putIgnoreCase(key2, null);
        } else {
            this.remove(key2);
        }
        return this;
    }

    public Attributes put(Attribute attribute) {
        Validate.notNull(attribute);
        this.put(attribute.getKey(), attribute.getValue());
        attribute.parent = this;
        return this;
    }

    private void remove(int index) {
        Validate.isFalse(index >= this.size);
        int shifted = this.size - index - 1;
        if (shifted > 0) {
            System.arraycopy(this.keys, index + 1, this.keys, index, shifted);
            System.arraycopy(this.vals, index + 1, this.vals, index, shifted);
        }
        --this.size;
        this.keys[this.size] = null;
        this.vals[this.size] = null;
    }

    public void remove(String key2) {
        int i = this.indexOfKey(key2);
        if (i != -1) {
            this.remove(i);
        }
    }

    public void removeIgnoreCase(String key2) {
        int i = this.indexOfKeyIgnoreCase(key2);
        if (i != -1) {
            this.remove(i);
        }
    }

    public boolean hasKey(String key2) {
        return this.indexOfKey(key2) != -1;
    }

    public boolean hasKeyIgnoreCase(String key2) {
        return this.indexOfKeyIgnoreCase(key2) != -1;
    }

    public boolean hasDeclaredValueForKey(String key2) {
        int i = this.indexOfKey(key2);
        return i != -1 && this.vals[i] != null;
    }

    public boolean hasDeclaredValueForKeyIgnoreCase(String key2) {
        int i = this.indexOfKeyIgnoreCase(key2);
        return i != -1 && this.vals[i] != null;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void addAll(Attributes incoming) {
        if (incoming.size() == 0) {
            return;
        }
        this.checkCapacity(this.size + incoming.size);
        boolean needsPut = this.size != 0;
        for (Attribute attr : incoming) {
            if (needsPut) {
                this.put(attr);
                continue;
            }
            this.add(attr.getKey(), attr.getValue());
        }
    }

    public Range.AttributeRange sourceRange(String key2) {
        if (!this.hasKey(key2)) {
            return Range.AttributeRange.UntrackedAttr;
        }
        Map<String, Range.AttributeRange> ranges = this.getRanges();
        if (ranges == null) {
            return Range.AttributeRange.UntrackedAttr;
        }
        Range.AttributeRange range = ranges.get(key2);
        return range != null ? range : Range.AttributeRange.UntrackedAttr;
    }

    @Nullable Map<String, Range.AttributeRange> getRanges() {
        return (Map)this.userData("jsoup.attrs");
    }

    public Attributes sourceRange(String key2, Range.AttributeRange range) {
        Validate.notNull(key2);
        Validate.notNull(range);
        Map<String, Range.AttributeRange> ranges = this.getRanges();
        if (ranges == null) {
            ranges = new HashMap<String, Range.AttributeRange>();
            this.userData("jsoup.attrs", ranges);
        }
        ranges.put(key2, range);
        return this;
    }

    @Override
    public Iterator<Attribute> iterator() {
        return new Iterator<Attribute>(){
            int expectedSize;
            int i;
            {
                this.expectedSize = Attributes.this.size;
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                this.checkModified();
                while (this.i < Attributes.this.size) {
                    String key2 = Attributes.this.keys[this.i];
                    assert (key2 != null);
                    if (!Attributes.isInternalKey(key2)) break;
                    ++this.i;
                }
                return this.i < Attributes.this.size;
            }

            @Override
            public Attribute next() {
                this.checkModified();
                if (this.i >= Attributes.this.size) {
                    throw new NoSuchElementException();
                }
                String key2 = Attributes.this.keys[this.i];
                assert (key2 != null);
                Attribute attr = new Attribute(key2, (String)Attributes.this.vals[this.i], Attributes.this);
                ++this.i;
                return attr;
            }

            private void checkModified() {
                if (Attributes.this.size != this.expectedSize) {
                    throw new ConcurrentModificationException("Use Iterator#remove() instead to remove attributes while iterating.");
                }
            }

            @Override
            public void remove() {
                Attributes.this.remove(--this.i);
                --this.expectedSize;
            }
        };
    }

    public List<Attribute> asList() {
        ArrayList<Attribute> list2 = new ArrayList<Attribute>(this.size);
        for (int i = 0; i < this.size; ++i) {
            String key2 = this.keys[i];
            assert (key2 != null);
            if (Attributes.isInternalKey(key2)) continue;
            Attribute attr = new Attribute(key2, (String)this.vals[i], this);
            list2.add(attr);
        }
        return Collections.unmodifiableList(list2);
    }

    public Map<String, String> dataset() {
        return new Dataset(this);
    }

    public String html() {
        StringBuilder sb = StringUtil.borrowBuilder();
        try {
            this.html(sb, new Document(EmptyString).outputSettings());
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return StringUtil.releaseBuilder(sb);
    }

    final void html(Appendable accum2, Document.OutputSettings out) throws IOException {
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            String validated;
            String key2 = this.keys[i];
            assert (key2 != null);
            if (Attributes.isInternalKey(key2) || (validated = Attribute.getValidKey(key2, out.syntax())) == null) continue;
            Attribute.htmlNoValidate(validated, (String)this.vals[i], accum2.append(' '), out);
        }
    }

    public String toString() {
        return this.html();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attributes that = (Attributes)o;
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            String key2 = this.keys[i];
            assert (key2 != null);
            int thatI = that.indexOfKey(key2);
            if (thatI != -1 && Objects.equals(this.vals[i], that.vals[thatI])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = this.size;
        result2 = 31 * result2 + Arrays.hashCode(this.keys);
        result2 = 31 * result2 + Arrays.hashCode(this.vals);
        return result2;
    }

    public Attributes clone() {
        Attributes clone;
        try {
            clone = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.size = this.size;
        clone.keys = Arrays.copyOf(this.keys, this.size);
        clone.vals = Arrays.copyOf(this.vals, this.size);
        return clone;
    }

    public void normalize() {
        for (int i = 0; i < this.size; ++i) {
            assert (this.keys[i] != null);
            String key2 = this.keys[i];
            assert (key2 != null);
            if (Attributes.isInternalKey(key2)) continue;
            this.keys[i] = Normalizer.lowerCase(key2);
        }
    }

    public int deduplicate(ParseSettings settings2) {
        if (this.isEmpty()) {
            return 0;
        }
        boolean preserve = settings2.preserveAttributeCase();
        int dupes = 0;
        for (int i = 0; i < this.size; ++i) {
            String keyI = this.keys[i];
            assert (keyI != null);
            for (int j = i + 1; j < this.size; ++j) {
                if ((!preserve || !keyI.equals(this.keys[j])) && (preserve || !keyI.equalsIgnoreCase(this.keys[j]))) continue;
                ++dupes;
                this.remove(j);
                --j;
            }
        }
        return dupes;
    }

    private static String dataKey(String key2) {
        return dataPrefix + key2;
    }

    static String internalKey(String key2) {
        return '/' + key2;
    }

    static boolean isInternalKey(String key2) {
        return key2.length() > 1 && key2.charAt(0) == '/';
    }

    private static class Dataset
    extends AbstractMap<String, String> {
        private final Attributes attributes;

        private Dataset(Attributes attributes) {
            this.attributes = attributes;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new EntrySet();
        }

        @Override
        public String put(String key2, String value) {
            String dataKey = Attributes.dataKey(key2);
            String oldValue = this.attributes.hasKey(dataKey) ? this.attributes.get(dataKey) : null;
            this.attributes.put(dataKey, value);
            return oldValue;
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<String, String>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new DatasetIterator();
            }

            @Override
            public int size() {
                int count = 0;
                DatasetIterator iter = new DatasetIterator();
                while (iter.hasNext()) {
                    ++count;
                }
                return count;
            }
        }

        private class DatasetIterator
        implements Iterator<Map.Entry<String, String>> {
            private final Iterator<Attribute> attrIter;
            private Attribute attr;

            private DatasetIterator() {
                this.attrIter = Dataset.this.attributes.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.attrIter.hasNext()) {
                    this.attr = this.attrIter.next();
                    if (!this.attr.isDataAttribute()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<String, String> next() {
                return new Attribute(this.attr.getKey().substring(Attributes.dataPrefix.length()), this.attr.getValue());
            }

            @Override
            public void remove() {
                Dataset.this.attributes.remove(this.attr.getKey());
            }
        }
    }
}

