/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes;

import coursierapi.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.LeafNode;
import java.io.IOException;
import org.jspecify.annotations.Nullable;

public class DocumentType
extends LeafNode {
    public DocumentType(String name, String publicId, String systemId) {
        super(name);
        Validate.notNull(publicId);
        Validate.notNull(systemId);
        this.attr("#doctype", name);
        this.attr("publicId", publicId);
        this.attr("systemId", systemId);
        this.updatePubSyskey();
    }

    public void setPubSysKey(@Nullable String value) {
        if (value != null) {
            this.attr("pubSysKey", value);
        }
    }

    private void updatePubSyskey() {
        if (this.has("publicId")) {
            this.attr("pubSysKey", "PUBLIC");
        } else if (this.has("systemId")) {
            this.attr("pubSysKey", "SYSTEM");
        }
    }

    public String name() {
        return this.attr("#doctype");
    }

    public String publicId() {
        return this.attr("publicId");
    }

    @Override
    public String nodeName() {
        return "#doctype";
    }

    @Override
    void outerHtmlHead(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        if (this.siblingIndex > 0 && out.prettyPrint()) {
            accum2.append('\n');
        }
        if (out.syntax() == Document.OutputSettings.Syntax.html && !this.has("publicId") && !this.has("systemId")) {
            accum2.append("<!doctype");
        } else {
            accum2.append("<!DOCTYPE");
        }
        if (this.has("#doctype")) {
            accum2.append(" ").append(this.attr("#doctype"));
        }
        if (this.has("pubSysKey")) {
            accum2.append(" ").append(this.attr("pubSysKey"));
        }
        if (this.has("publicId")) {
            accum2.append(" \"").append(this.attr("publicId")).append('\"');
        }
        if (this.has("systemId")) {
            accum2.append(" \"").append(this.attr("systemId")).append('\"');
        }
        accum2.append('>');
    }

    @Override
    void outerHtmlTail(Appendable accum2, int depth, Document.OutputSettings out) {
    }

    private boolean has(String attribute) {
        return !StringUtil.isBlank(this.attr(attribute));
    }
}

