/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.util.shaded.org.jsoup.parser;

import coursierapi.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;

public class TokenQueue {
    private String queue;
    private int pos = 0;
    private static final String[] ElementSelectorChars = new String[]{"*", "|", "_", "-"};
    private static final String[] CssIdentifierChars = new String[]{"-", "_"};

    public TokenQueue(String data) {
        Validate.notNull(data);
        this.queue = data;
    }

    public boolean isEmpty() {
        return this.remainingLength() == 0;
    }

    private int remainingLength() {
        return this.queue.length() - this.pos;
    }

    public boolean matches(String seq) {
        return this.queue.regionMatches(true, this.pos, seq, 0, seq.length());
    }

    public boolean matchesAny(String ... seq) {
        for (String s : seq) {
            if (!this.matches(s)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        for (char c : seq) {
            if (this.queue.charAt(this.pos) != c) continue;
            return true;
        }
        return false;
    }

    public boolean matchChomp(String seq) {
        if (this.matches(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return !this.isEmpty() && StringUtil.isWhitespace(this.queue.charAt(this.pos));
    }

    public boolean matchesWord() {
        return !this.isEmpty() && Character.isLetterOrDigit(this.queue.charAt(this.pos));
    }

    public char consume() {
        return this.queue.charAt(this.pos++);
    }

    public String consumeToAny(String ... seq) {
        int start = this.pos;
        while (!this.isEmpty() && !this.matchesAny(seq)) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String chompBalanced(char open, char close2) {
        String out;
        int start = -1;
        int end = -1;
        int depth = 0;
        int last = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inRegexQE = false;
        while (!this.isEmpty()) {
            block15: {
                char c;
                block16: {
                    block13: {
                        block14: {
                            c = this.consume();
                            if (last == 92) break block13;
                            if (c == '\'' && c != open && !inDoubleQuote) {
                                inSingleQuote = !inSingleQuote;
                            } else if (c == '\"' && c != open && !inSingleQuote) {
                                boolean bl = inDoubleQuote = !inDoubleQuote;
                            }
                            if (!inSingleQuote && !inDoubleQuote && !inRegexQE) break block14;
                            last = c;
                            break block15;
                        }
                        if (c == open) {
                            ++depth;
                            if (start == -1) {
                                start = this.pos;
                            }
                        } else if (c == close2) {
                            --depth;
                        }
                        break block16;
                    }
                    if (c == 'Q') {
                        inRegexQE = true;
                    } else if (c == 'E') {
                        inRegexQE = false;
                    }
                }
                if (depth > 0 && last != 0) {
                    end = this.pos;
                }
                last = c;
            }
            if (depth > 0) continue;
        }
        String string = out = end >= 0 ? this.queue.substring(start, end) : "";
        if (depth > 0) {
            Validate.fail("Did not find balanced marker at '" + out + "'");
        }
        return out;
    }

    public static String unescape(String in) {
        StringBuilder out = StringUtil.borrowBuilder();
        char last = '\u0000';
        for (char c : in.toCharArray()) {
            if (c == '\\') {
                if (last == '\\') {
                    out.append(c);
                    c = '\u0000';
                }
            } else {
                out.append(c);
            }
            last = c;
        }
        return StringUtil.releaseBuilder(out);
    }

    public boolean consumeWhitespace() {
        boolean seen = false;
        while (this.matchesWhitespace()) {
            ++this.pos;
            seen = true;
        }
        return seen;
    }

    public String consumeElementSelector() {
        return this.consumeEscapedCssIdentifier(ElementSelectorChars);
    }

    public String consumeCssIdentifier() {
        return this.consumeEscapedCssIdentifier(CssIdentifierChars);
    }

    private String consumeEscapedCssIdentifier(String ... matches) {
        int start = this.pos;
        boolean escaped = false;
        while (!this.isEmpty()) {
            if (this.queue.charAt(this.pos) == '\\' && this.remainingLength() > 1) {
                escaped = true;
                this.pos += 2;
                continue;
            }
            if (!this.matchesCssIdentifier(matches)) break;
            ++this.pos;
        }
        String consumed = this.queue.substring(start, this.pos);
        return escaped ? TokenQueue.unescape(consumed) : consumed;
    }

    private boolean matchesCssIdentifier(String ... matches) {
        return this.matchesWord() || this.matchesAny(matches);
    }

    public String remainder() {
        String remainder = this.queue.substring(this.pos);
        this.pos = this.queue.length();
        return remainder;
    }

    public String toString() {
        return this.queue.substring(this.pos);
    }
}

