/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.parse;

public class Position {
    private final String name;
    private int line;
    private int col;

    Position(String name) {
        this(name, 1, 0);
    }

    private Position(String name, int line, int col) {
        this.name = name;
        this.line = line;
        this.col = col;
    }

    Position copy(int delta) {
        return new Position(this.name, this.line, this.col + delta);
    }

    void newLine() {
        this.col = 0;
        ++this.line;
    }

    void newChar() {
        ++this.col;
    }

    void lastChar() {
        --this.col;
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public String toString() {
        return this.name + ":" + this.line + ":" + this.col;
    }
}

