/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import geny.Readable;
import geny.Readable$;
import geny.Writable;
import geny.Writable$;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import mill.api.DummyInputStream$;
import mill.api.SystemStreams;
import mill.api.SystemStreams$ThreadLocalStreams$;
import mill.api.SystemStreams$ThreadLocalStreams$Err$;
import mill.api.SystemStreams$ThreadLocalStreams$In$;
import mill.api.SystemStreams$ThreadLocalStreams$Out$;
import mill.main.client.DebugLog;
import mill.moduledefs.Scaladoc;
import os.Inherit$;
import os.InheritRaw$;
import os.ProcessInput$;
import os.ProcessOutput;
import os.Source;
import os.Source$;
import pprint.package$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxedUnit;

public final class SystemStreams$ {
    public static final SystemStreams$ MODULE$ = new SystemStreams$();
    @Scaladoc(value="/**\n   * The original system streams of this process, before any redirection.\n   *\n   * NOTE: you should not use this! They do not get captured properly by Mill's stdout/err\n   * redirection, and thus only get picked up from the Mill server log files asynchronously.\n   * That means that the logs may appear out of order, jumbling your logs and screwing up\n   * your terminal\n   */")
    private static final SystemStreams original = new SystemStreams(System.out, System.err, System.in);

    public SystemStreams original() {
        return original;
    }

    @Scaladoc(value="/**\n   * Used to check whether the system streams are all \"original\", i,e. they\n   * have not been overridden. Used for code paths that need to work differently\n   * if they have been overridden (e.g. handling subprocess stdout/stderr)\n   *\n   * Assumes that the application only uses [[withStreams]] to override\n   * stdout/stderr/stdin.\n   */")
    public boolean isOriginal() {
        return Console$.MODULE$.out() == this.original().out() && Console$.MODULE$.err() == this.original().err();
    }

    @Scaladoc(value="/**\n   * The original non-override stderr, used for debugging purposes e.g. if you\n   * want to print stuff while the system streams override are messed up\n   */")
    public PrintStream originalErr() {
        return this.original().err();
    }

    public <T> T withStreams(SystemStreams systemStreams, Function0<T> t) {
        InheritRaw$ inheritIn = systemStreams.in() == this.original().in() ? InheritRaw$.MODULE$ : ProcessInput$.MODULE$.makeSourceInput(DummyInputStream$.MODULE$, (Function1<DummyInputStream$, Source.WritableSource> & Serializable)s -> Source$.MODULE$.WritableSource(s, (Function1<DummyInputStream$, Writable> & Serializable)t -> Writable$.MODULE$.readableWritable(t, (Function1<InputStream, Readable.InputStreamReadable> & Serializable)i -> Readable$.MODULE$.InputStreamReadable((InputStream)i))));
        ProcessOutput inheritOut = systemStreams.out() == this.original().out() ? InheritRaw$.MODULE$ : new SystemStreams.PumpedProcessOutput(systemStreams.out());
        ProcessOutput inheritErr = systemStreams.err() == this.original().err() ? InheritRaw$.MODULE$ : new SystemStreams.PumpedProcessOutput(systemStreams.err());
        return (T)SystemStreams$ThreadLocalStreams$.MODULE$.current().withValue(systemStreams, (Function0<Object> & Serializable)() -> Console$.MODULE$.withIn(systemStreams.in(), (Function0<Object> & Serializable)() -> Console$.MODULE$.withOut(systemStreams.out(), (Function0<Object> & Serializable)() -> Console$.MODULE$.withErr(systemStreams.err(), (Function0<Object> & Serializable)() -> Inherit$.MODULE$.in().withValue(inheritIn, (Function0<Object> & Serializable)() -> Inherit$.MODULE$.out().withValue(inheritOut, (Function0<Object> & Serializable)() -> Inherit$.MODULE$.err().withValue(inheritErr, t)))))));
    }

    @Scaladoc(value="/**\n   * Manages the global override of `System.{in,out,err}`. Overrides of those streams are\n   * global, so we cannot just override them per-use-site in a multithreaded environment\n   * because different threads may interleave and stomp over each other's over-writes.\n   * Instead, we over-write them globally with a set of streams that does nothing but\n   * forward to the per-thread [[ThreadLocalStreams.current]] streams, allowing callers\n   * to each reach their own thread-local streams without clashing across multiple threads\n   */")
    public <T> T withTopLevelSystemStreamProxy(Function0<T> t) {
        T t2;
        InputStream in = System.in;
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            this.setTopLevelSystemStreamProxy();
            t2 = t.apply();
        }
        finally {
            System.setErr(err);
            System.setOut(out);
            System.setIn(in);
        }
        return t2;
    }

    public void setTopLevelSystemStreamProxy() {
        PrintStream printStream = Console$.MODULE$.out();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        PrintStream printStream2 = Console$.MODULE$.err();
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        BufferedReader bufferedReader = Console$.MODULE$.in();
        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        System.setIn(SystemStreams$ThreadLocalStreams$In$.MODULE$);
        System.setOut(SystemStreams$ThreadLocalStreams$Out$.MODULE$);
        System.setErr(SystemStreams$ThreadLocalStreams$Err$.MODULE$);
    }

    public void mill$api$SystemStreams$$debugPrintln(String s) {
        DebugLog.println(package$.MODULE$.apply(s.toCharArray(), 999, package$.MODULE$.apply$default$3(), package$.MODULE$.apply$default$4(), package$.MODULE$.apply$default$5(), package$.MODULE$.apply$default$6(), package$.MODULE$.apply$default$7()).toString());
    }

    private SystemStreams$() {
    }
}

