/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader;

import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassLoader;
import se.jiderhamn.classloader.ZombieMarker;

public class RedefiningClassLoader
extends ClassLoader {
    public static final String[] DEFAULT_IGNORED_PACKAGES = new String[]{"java.", "javax.", "jdk.", "com.sun.", "sun.", "org.w3c", "org.junit.", "junit.", "com.apple.eawt.", "com.apple.eio.", "com.apple.laf."};
    private ZombieMarker zombieMarker = null;
    private final String name;
    private final boolean logRedefinitions;

    public RedefiningClassLoader(java.lang.ClassLoader parent) {
        this(parent, null);
    }

    public RedefiningClassLoader() {
        this((String)null);
    }

    public RedefiningClassLoader(java.lang.ClassLoader parent, String name) {
        this(parent, name, DEFAULT_IGNORED_PACKAGES);
    }

    RedefiningClassLoader(String name) {
        this(name, DEFAULT_IGNORED_PACKAGES);
    }

    public RedefiningClassLoader(java.lang.ClassLoader parent, String name, String[] ignoredPackages) {
        super(parent, ignoredPackages);
        this.name = name;
        this.logRedefinitions = "true".equals(System.getProperty("ClassLoaderLeakTestFramework.debug"));
    }

    RedefiningClassLoader(String name, String[] ignoredPackages) {
        super(ignoredPackages);
        this.name = name;
        this.logRedefinitions = "true".equals(System.getProperty("ClassLoaderLeakTestFramework.debug"));
    }

    protected JavaClass modifyClass(JavaClass clazz) {
        if (this.logRedefinitions) {
            System.out.println("Loading " + clazz.getClassName() + " in " + (Object)((Object)this));
        }
        return super.modifyClass(clazz);
    }

    public void markAsZombie() {
        this.zombieMarker = new ZombieMarker();
    }

    public String toString() {
        return this.name != null ? ((Object)((Object)this)).getClass().getName() + '[' + this.name + "]@" + Integer.toHexString(System.identityHashCode((Object)this)) : super.toString();
    }

    protected Class<?> loadClass(String class_name, boolean resolve) throws ClassNotFoundException {
        try {
            String pkgName;
            int i = class_name.lastIndexOf(46);
            if (i != -1 && this.getPackage(pkgName = class_name.substring(0, i)) == null) {
                super.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            return super.loadClass(class_name, resolve);
        }
        catch (ClassFormatException e) {
            throw new RuntimeException("Unable to load class " + class_name, e);
        }
    }
}

