/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ModelExtensionPoint;
import org.java.plugin.registry.xml.ModelParameterDef;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

class ExtensionPointImpl
extends PluginElementImpl
implements ExtensionPoint {
    private final ModelExtensionPoint model;
    private Map connectedExtensions;
    private List parameterDefinitions;
    private Boolean isValid;
    private boolean paramDefsMerged = false;
    private List descendants;

    ExtensionPointImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelExtensionPoint modelExtensionPoint) throws ManifestProcessingException {
        super(pluginDescriptorImpl, pluginFragmentImpl, modelExtensionPoint.getId(), modelExtensionPoint.getDocumentation());
        this.model = modelExtensionPoint;
        if (this.model.getParentPointId() != null && this.model.getParentPluginId() == null) {
            this.log.warn("parent plug-in ID not specified together with parent extension point ID, using declaring plug-in ID, extension point is " + this.getUniqueId());
            this.model.setParentPluginId(pluginDescriptorImpl.getId());
        }
        this.parameterDefinitions = new ArrayList(this.model.getParamDefs().size());
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.model.getParamDefs().iterator();
        while (iterator.hasNext()) {
            ParameterDefinitionImpl parameterDefinitionImpl = new ParameterDefinitionImpl(null, (ModelParameterDef)iterator.next());
            if (hashSet.contains(parameterDefinitionImpl.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateParameterDefinition", new Object[]{parameterDefinitionImpl.getId(), this.getId(), pluginDescriptorImpl.getId()});
            }
            hashSet.add(parameterDefinitionImpl.getId());
            this.parameterDefinitions.add(parameterDefinitionImpl);
        }
        this.parameterDefinitions = Collections.unmodifiableList(this.parameterDefinitions);
        this.log.debug("object instantiated: " + this);
    }

    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    public String getMultiplicity() {
        return this.model.getExtensionMultiplicity();
    }

    private void updateConnectedExtensionsList() {
        this.connectedExtensions = new HashMap();
        Iterator iterator = this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptors().iterator();
        while (iterator.hasNext()) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)iterator.next();
            Iterator iterator2 = pluginDescriptor.getExtensions().iterator();
            while (iterator2.hasNext()) {
                Extension extension = (Extension)iterator2.next();
                if (!this.getDeclaringPluginDescriptor().getId().equals(extension.getExtendedPluginId()) || !this.getId().equals(extension.getExtendedPointId())) continue;
                if (extension.isValid()) {
                    this.log.debug("extension " + extension + " connected to point " + this);
                    this.connectedExtensions.put(extension.getUniqueId(), extension);
                    continue;
                }
                this.log.warn("extension " + extension.getUniqueId() + " is invalid and doesn't connected to" + " extension point " + this.getUniqueId());
            }
        }
    }

    public Collection getConnectedExtensions() {
        if (this.connectedExtensions == null) {
            this.updateConnectedExtensionsList();
        }
        return Collections.unmodifiableCollection(this.connectedExtensions.values());
    }

    public Extension getConnectedExtension(String string) {
        Extension extension;
        if (this.connectedExtensions == null) {
            this.updateConnectedExtensionsList();
        }
        if ((extension = (Extension)this.connectedExtensions.get(string)) == null) {
            throw new IllegalArgumentException("extension " + string + " not connected to point " + this.getUniqueId());
        }
        return extension;
    }

    public boolean isExtensionConnected(String string) {
        if (this.connectedExtensions == null) {
            this.updateConnectedExtensionsList();
        }
        return this.connectedExtensions.containsKey(string);
    }

    public boolean isValid() {
        if (this.isValid == null) {
            this.validate();
        }
        return this.isValid;
    }

    Collection validate() {
        if (this.model.getParentPluginId() != null && this.model.getParentPointId() != null) {
            try {
                if (!this.getDeclaringPluginDescriptor().getRegistry().isExtensionPointAvailable(this.model.getParentPluginId(), this.model.getParentPointId())) {
                    this.isValid = Boolean.FALSE;
                    return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "parentExtPointNotAvailable", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId()), this.getUniqueId()}));
                }
            }
            catch (Throwable throwable) {
                this.isValid = Boolean.FALSE;
                this.log.debug("failed checking availability of extension point " + this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId()), throwable);
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "parentExtPointAvailabilityCheckFailed", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId()), this.getUniqueId(), throwable}));
            }
        }
        if ("any".equals(this.getMultiplicity())) {
            this.isValid = Boolean.TRUE;
            return Collections.EMPTY_LIST;
        }
        if ("one".equals(this.getMultiplicity())) {
            this.isValid = this.getConnectedExtensions().size() == 1;
            if (!this.isValid.booleanValue()) {
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "toManyOrFewExtsConnected", this.getUniqueId()));
            }
        } else if ("none".equals(this.getMultiplicity())) {
            this.isValid = this.getConnectedExtensions().size() == 0;
            if (!this.isValid.booleanValue()) {
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "extsConnectedToAbstractExtPoint", this.getUniqueId()));
            }
        } else {
            this.isValid = Boolean.TRUE;
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.getConnectedExtensions().iterator();
            while (iterator.hasNext()) {
                String string = ((Extension)iterator.next()).getDeclaringPluginDescriptor().getId();
                if (hashSet.add(string)) continue;
                this.isValid = Boolean.FALSE;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "toManyExtsConnected", this.getUniqueId()));
            }
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getParameterDefinitions() {
        ExtensionPoint.ParameterDefinition parameterDefinition;
        if (this.model.getParentPluginId() == null || this.model.getParentPointId() == null || this.paramDefsMerged) {
            return this.parameterDefinitions;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.model.getParentPluginId(), this.model.getParentPointId()).getParameterDefinitions();
        ArrayList<ExtensionPoint.ParameterDefinition> arrayList = new ArrayList<ExtensionPoint.ParameterDefinition>(this.parameterDefinitions.size() + collection.size());
        Iterator iterator = this.parameterDefinitions.iterator();
        while (iterator.hasNext()) {
            parameterDefinition = (ExtensionPoint.ParameterDefinition)iterator.next();
            hashSet.add(parameterDefinition.getId());
            arrayList.add(parameterDefinition);
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            parameterDefinition = (ExtensionPoint.ParameterDefinition)iterator.next();
            if (hashSet.contains(parameterDefinition.getId())) continue;
            arrayList.add(parameterDefinition);
        }
        this.paramDefsMerged = true;
        this.parameterDefinitions = Collections.unmodifiableList(arrayList);
        return this.parameterDefinitions;
    }

    public ExtensionPoint.ParameterDefinition getParameterDefinition(String string) {
        Iterator iterator = this.getParameterDefinitions().iterator();
        while (iterator.hasNext()) {
            ParameterDefinitionImpl parameterDefinitionImpl = (ParameterDefinitionImpl)iterator.next();
            if (!parameterDefinitionImpl.getId().equals(string)) continue;
            return parameterDefinitionImpl;
        }
        throw new IllegalArgumentException("parameter definition with ID " + string + " not found in extension point " + this.getUniqueId() + " and all it parents");
    }

    public String getParentPluginId() {
        return this.model.getParentPluginId();
    }

    public String getParentExtensionPointId() {
        return this.model.getParentPointId();
    }

    public boolean isSuccessorOf(ExtensionPoint extensionPoint) {
        if (this.model.getParentPluginId() == null || this.model.getParentPointId() == null) {
            return false;
        }
        if (this.model.getParentPluginId().equals(extensionPoint.getDeclaringPluginDescriptor().getId()) && this.model.getParentPointId().equals(extensionPoint.getId())) {
            return true;
        }
        try {
            return this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.model.getParentPluginId(), this.model.getParentPointId()).isSuccessorOf(extensionPoint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private void collectDescendants() {
        this.descendants = new LinkedList();
        Iterator iterator = this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptors().iterator();
        while (iterator.hasNext()) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)iterator.next();
            Iterator iterator2 = pluginDescriptor.getExtensionPoints().iterator();
            while (iterator2.hasNext()) {
                ExtensionPoint extensionPoint = (ExtensionPoint)iterator2.next();
                if (!extensionPoint.isSuccessorOf(this)) continue;
                this.log.debug("extension point " + extensionPoint + " is descendant of point " + this);
                this.descendants.add(extensionPoint);
            }
        }
        this.descendants = Collections.unmodifiableList(this.descendants);
    }

    public Collection getDescendants() {
        if (this.descendants == null) {
            this.collectDescendants();
        }
        return this.descendants;
    }

    public String toString() {
        return "{ExtensionPoint: uid=" + this.getUniqueId() + "}";
    }

    void registryChanged() {
        this.isValid = null;
        this.connectedExtensions = null;
        this.descendants = null;
    }

    private class ParameterDefinitionImpl
    extends PluginElementImpl
    implements ExtensionPoint.ParameterDefinition {
        private List subDefinitions;
        private final ParameterDefinitionImpl superDefinition;
        private final ModelParameterDef modelParamDef;

        ParameterDefinitionImpl(ParameterDefinitionImpl parameterDefinitionImpl, ModelParameterDef modelParameterDef) throws ManifestProcessingException {
            super(ExtensionPointImpl.this.getDeclaringPluginDescriptor(), ExtensionPointImpl.this.getDeclaringPluginFragment(), modelParameterDef.getId(), modelParameterDef.getDocumentation());
            this.superDefinition = parameterDefinitionImpl;
            this.modelParamDef = modelParameterDef;
            this.checkType();
            this.checkMultiplicity();
            if ("any".equals(this.modelParamDef.getType())) {
                this.subDefinitions = Collections.EMPTY_LIST;
            } else {
                this.subDefinitions = new ArrayList(this.modelParamDef.getParamDefs().size());
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = this.modelParamDef.getParamDefs().iterator();
                while (iterator.hasNext()) {
                    ParameterDefinitionImpl parameterDefinitionImpl2 = new ParameterDefinitionImpl(this, (ModelParameterDef)iterator.next());
                    if (hashSet.contains(parameterDefinitionImpl2.getId())) {
                        throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateParameterDefinition", new Object[]{parameterDefinitionImpl2.getId(), ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
                    }
                    hashSet.add(parameterDefinitionImpl2.getId());
                    this.subDefinitions.add(parameterDefinitionImpl2);
                }
                this.subDefinitions = Collections.unmodifiableList(this.subDefinitions);
            }
            this.log.debug("object instantiated: " + this);
        }

        private void checkType() throws ManifestProcessingException {
            String string = this.modelParamDef.getType();
            if (!("string".equals(string) || "boolean".endsWith(string) || "number".equals(string) || "date".equals(string) || "time".equals(string) || "date-time".equals(string) || "null".equals(string) || "any".equals(string) || "plugin-id".equals(string) || "extension-point-id".equals(string) || "extension-id".equals(string) || "fixed".equals(string) || "resource".equals(string))) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidTypeAttribute", new Object[]{string, ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
            }
        }

        private void checkMultiplicity() throws ManifestProcessingException {
            String string = this.modelParamDef.getMultiplicity();
            if (!("one".equals(string) || "any".equals(string) || "none-or-one".equals(string) || "one-or-more".equals(string))) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidMultiplicityAttribute", new Object[]{string, ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
            }
        }

        public ExtensionPoint getDeclaringExtensionPoint() {
            return ExtensionPointImpl.this;
        }

        public String getMultiplicity() {
            return this.modelParamDef.getMultiplicity();
        }

        public Collection getSubDefinitions() {
            return this.subDefinitions;
        }

        public ExtensionPoint.ParameterDefinition getSuperDefinition() {
            return this.superDefinition;
        }

        public ExtensionPoint.ParameterDefinition getSubDefinition(String string) {
            Iterator iterator = this.subDefinitions.iterator();
            while (iterator.hasNext()) {
                ParameterDefinitionImpl parameterDefinitionImpl = (ParameterDefinitionImpl)iterator.next();
                if (!parameterDefinitionImpl.getId().equals(string)) continue;
                return parameterDefinitionImpl;
            }
            throw new IllegalArgumentException("parameter definition with ID " + string + " not found in extension point " + ExtensionPointImpl.this.getUniqueId());
        }

        public String getType() {
            return this.modelParamDef.getType();
        }

        public String getCustomData() {
            return this.modelParamDef.getCustomData();
        }

        public String toString() {
            return "{PluginExtensionPoint.ParameterDefinition: extPointUid=" + this.getDeclaringExtensionPoint().getUniqueId() + "; id=" + this.getId() + "}";
        }

        protected boolean isEqualTo(Identity identity) {
            if (!super.isEqualTo(identity)) {
                return false;
            }
            ParameterDefinitionImpl parameterDefinitionImpl = (ParameterDefinitionImpl)identity;
            if (this.getSuperDefinition() == null && parameterDefinitionImpl.getSuperDefinition() == null) {
                return true;
            }
            if (this.getSuperDefinition() == null || parameterDefinitionImpl.getSuperDefinition() == null) {
                return false;
            }
            return this.getSuperDefinition().equals(parameterDefinitionImpl.getSuperDefinition());
        }
    }
}

