/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.docgen;

import java.io.IOException;
import java.io.InputStreamReader;
import org.onemind.commons.java.util.FileUtils;
import org.onemind.jxp.CachedJxpPage;
import org.onemind.jxp.CachingPageSource;
import org.onemind.jxp.JxpPage;
import org.onemind.jxp.JxpPageNotFoundException;
import org.onemind.jxp.JxpPageParseException;
import org.onemind.jxp.parser.AstJxpDocument;
import org.onemind.jxp.parser.JxpParser;
import org.onemind.jxp.parser.ParseException;

final class ClassPathPageSource
extends CachingPageSource {
    private final String base;
    private final ClassLoader cl;
    private final String encoding;

    ClassPathPageSource(String string, String string2) {
        this.base = string;
        this.encoding = string2;
        this.cl = this.getClass().getClassLoader();
    }

    protected CachedJxpPage loadJxpPage(String string) throws JxpPageNotFoundException {
        if (!this.hasJxpPage(string)) {
            throw new JxpPageNotFoundException("page " + string + " not found");
        }
        return new CachedJxpPage(this, string);
    }

    protected AstJxpDocument parseJxpDocument(JxpPage jxpPage) throws JxpPageParseException {
        try {
            JxpParser jxpParser = this.encoding == null ? new JxpParser(this.cl.getResourceAsStream(this.getStreamName(jxpPage.getName()))) : new JxpParser(new InputStreamReader(this.cl.getResourceAsStream(this.getStreamName(jxpPage.getName())), this.encoding));
            return jxpParser.JxpDocument();
        }
        catch (IOException iOException) {
            throw new JxpPageParseException("problem parsing page " + jxpPage.getName() + ": " + iOException.getMessage(), iOException);
        }
        catch (ParseException parseException) {
            throw new JxpPageParseException("problem parsing page " + jxpPage.getName() + ": " + parseException.getMessage(), parseException);
        }
    }

    public boolean hasJxpPage(String string) {
        if (this.isJxpPageCached(string)) {
            return true;
        }
        return this.cl.getResource(this.getStreamName(string)) != null;
    }

    private String getStreamName(String string) {
        return FileUtils.concatFilePath(this.base, string);
    }
}

