/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.docgen;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.UniqueIdentity;
import org.java.plugin.tools.docgen.ClassPathPageSource;
import org.java.plugin.util.IoUtil;
import org.onemind.jxp.FilePageSource;
import org.onemind.jxp.JxpProcessingContext;
import org.onemind.jxp.JxpProcessor;

public final class DocGenerator {
    private final PluginRegistry registry;
    private final PathResolver pathResolver;
    private JxpProcessor processor;
    private Collection allPluginDescriptors;
    private Collection allPluginFragments;
    private Collection allExtensionPoints;
    private Collection allExtensions;
    private String documentationOverview;
    private String stylesheet;
    private String outputEncoding = "UTF-8";
    static /* synthetic */ Class class$org$java$plugin$tools$docgen$DocGenerator;

    private static String getRelativePath(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append("/");
                }
                stringBuffer.append("..");
            }
        } else {
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public DocGenerator(PluginRegistry pluginRegistry, PathResolver pathResolver) throws Exception {
        this(pluginRegistry, pathResolver, (class$org$java$plugin$tools$docgen$DocGenerator == null ? (class$org$java$plugin$tools$docgen$DocGenerator = DocGenerator.class$("org.java.plugin.tools.docgen.DocGenerator")) : class$org$java$plugin$tools$docgen$DocGenerator).getName().substring(0, (class$org$java$plugin$tools$docgen$DocGenerator == null ? (class$org$java$plugin$tools$docgen$DocGenerator = DocGenerator.class$("org.java.plugin.tools.docgen.DocGenerator")) : class$org$java$plugin$tools$docgen$DocGenerator).getName().lastIndexOf(46)).replace('.', '/') + "/templates/", null);
    }

    public DocGenerator(PluginRegistry pluginRegistry, PathResolver pathResolver, String string, String string2) throws Exception {
        this(pluginRegistry, pathResolver, new JxpProcessor(new ClassPathPageSource(string, string2)));
    }

    public DocGenerator(PluginRegistry pluginRegistry, PathResolver pathResolver, File file, String string) throws Exception {
        this(pluginRegistry, pathResolver, new JxpProcessor(new FilePageSource(file.getCanonicalPath())));
    }

    private DocGenerator(PluginRegistry pluginRegistry, PathResolver pathResolver, JxpProcessor jxpProcessor) {
        this.registry = pluginRegistry;
        this.pathResolver = pathResolver;
        this.processor = jxpProcessor;
        this.allPluginDescriptors = this.getAllPluginDescriptors();
        this.allPluginFragments = this.getAllPluginFragments();
        this.allExtensionPoints = this.getAllExtensionPoints();
        this.allExtensions = this.getAllExtensions();
    }

    public String getDocumentationOverview() {
        return this.documentationOverview;
    }

    public void setDocumentationOverview(String string) {
        this.documentationOverview = string;
    }

    public String getStylesheet() {
        return this.stylesheet;
    }

    public void setStylesheet(String string) {
        this.stylesheet = string;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTemplateFile(Map map, String string, File file) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file, false)), this.outputEncoding);
        try {
            this.processor.process(string, new JxpProcessingContext(outputStreamWriter, map));
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTemplateContent(Map map, String string, File file) throws Exception {
        File file2 = File.createTempFile("~jpf-jxp", null);
        file2.deleteOnExit();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file2, false)), "UTF-8");
        try {
            outputStreamWriter.write(string);
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
        OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file, false)), this.outputEncoding);
        try {
            JxpProcessor jxpProcessor = new JxpProcessor(new FilePageSource(file2.getParentFile().getCanonicalPath()));
            jxpProcessor.process(file2.getName(), new JxpProcessingContext(outputStreamWriter2, map));
        }
        finally {
            file2.delete();
            ((Writer)outputStreamWriter2).close();
        }
    }

    public void generate(File file) throws Exception {
        Map map = this.createConext(0);
        this.processTemplateFile(map, "index.jxp", new File(file, "index.html"));
        this.generateCss(file);
        map = this.createConext(0);
        this.processTemplateFile(map, "menu.jxp", new File(file, "menu.html"));
        map = this.createConext(0);
        if (this.documentationOverview != null) {
            map.put("overview", this.documentationOverview.replaceAll("(?i)(?d)(?m).*<body>(.*)</body>.*", "$1"));
        } else {
            map.put("overview", "");
        }
        this.processTemplateFile(map, "overview.jxp", new File(file, "overview.html"));
        map = this.createConext(0);
        this.processTemplateFile(map, "allplugins.jxp", new File(file, "allplugins.html"));
        map = this.createConext(0);
        this.processTemplateFile(map, "allfragments.jxp", new File(file, "allfragments.html"));
        map = this.createConext(0);
        this.processTemplateFile(map, "allextpoints.jxp", new File(file, "allextpoints.html"));
        map = this.createConext(0);
        this.processTemplateFile(map, "allexts.jxp", new File(file, "allexts.html"));
        map = this.createConext(0);
        this.processTemplateFile(map, "tree.jxp", new File(file, "tree.html"));
        Iterator iterator = this.registry.getPluginDescriptors().iterator();
        while (iterator.hasNext()) {
            this.generateForPluginDescriptor(file, (PluginDescriptor)iterator.next());
        }
    }

    private void generateCss(File file) throws Exception {
        Map map = this.createConext(0);
        if (this.stylesheet == null) {
            this.processTemplateFile(map, "stylesheet.jxp", new File(file, "stylesheet.css"));
        } else {
            this.processTemplateContent(map, this.stylesheet, new File(file, "stylesheet.css"));
        }
    }

    private void generateForPluginDescriptor(File file, PluginDescriptor pluginDescriptor) throws Exception {
        File file2;
        UniqueIdentity uniqueIdentity;
        Iterator iterator;
        Object object;
        Serializable serializable;
        File file3 = new File(file, pluginDescriptor.getId());
        file3.mkdirs();
        File file4 = IoUtil.url2file(this.pathResolver.resolvePath(pluginDescriptor, pluginDescriptor.getDocsPath()));
        if (file4 != null && file4.isDirectory()) {
            serializable = new File(file3, "extra");
            ((File)serializable).mkdir();
            IoUtil.copyFolder(file4, (File)serializable, true);
        }
        serializable = new LinkedList();
        Object object2 = this.registry.getPluginDescriptors().iterator();
        block0: while (object2.hasNext()) {
            object = (PluginDescriptor)object2.next();
            if (object.getId().equals(pluginDescriptor.getId())) continue;
            iterator = object.getPrerequisites().iterator();
            while (iterator.hasNext()) {
                uniqueIdentity = (PluginPrerequisite)iterator.next();
                if (!uniqueIdentity.getPluginId().equals(pluginDescriptor.getId()) || !uniqueIdentity.matches()) continue;
                serializable.add(object);
                continue block0;
            }
        }
        object2 = this.createConext(1);
        object2.put("descriptor", pluginDescriptor);
        object2.put("dependedPlugins", serializable);
        this.processTemplateFile((Map)object2, "plugin.jxp", new File(file3, "index.html"));
        object = pluginDescriptor.getFragments().iterator();
        while (object.hasNext()) {
            this.generateForPluginFragment(file, (PluginFragment)object.next());
        }
        if (!pluginDescriptor.getExtensionPoints().isEmpty()) {
            object = new File(file3, "extp");
            ((File)object).mkdir();
            iterator = pluginDescriptor.getExtensionPoints().iterator();
            while (iterator.hasNext()) {
                uniqueIdentity = (ExtensionPoint)iterator.next();
                object2 = this.createConext(3);
                object2.put("extPoint", uniqueIdentity);
                file2 = new File((File)object, uniqueIdentity.getId());
                file2.mkdir();
                this.processTemplateFile((Map)object2, "extpoint.jxp", new File(file2, "index.html"));
            }
        }
        if (!pluginDescriptor.getExtensions().isEmpty()) {
            object = new File(file3, "ext");
            ((File)object).mkdir();
            iterator = pluginDescriptor.getExtensions().iterator();
            while (iterator.hasNext()) {
                uniqueIdentity = (Extension)iterator.next();
                object2 = this.createConext(3);
                object2.put("ext", uniqueIdentity);
                file2 = new File((File)object, uniqueIdentity.getId());
                file2.mkdir();
                this.processTemplateFile((Map)object2, "ext.jxp", new File(file2, "index.html"));
            }
        }
    }

    private void generateForPluginFragment(File file, PluginFragment pluginFragment) throws Exception {
        File file2 = new File(file, pluginFragment.getId());
        file2.mkdirs();
        Map map = this.createConext(1);
        map.put("fragment", pluginFragment);
        this.processTemplateFile(map, "fragment.jxp", new File(file2, "index.html"));
    }

    private Map createConext(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = DocGenerator.getRelativePath(n);
        hashMap.put("tool", new Tool(string));
        hashMap.put("relativePath", string);
        hashMap.put("registry", this.registry);
        hashMap.put("allPluginDescriptors", this.allPluginDescriptors);
        hashMap.put("allPluginFragments", this.allPluginFragments);
        hashMap.put("allExtensionPoints", this.allExtensionPoints);
        hashMap.put("allExtensions", this.allExtensions);
        return hashMap;
    }

    private Collection getAllPluginDescriptors() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.registry.getPluginDescriptors());
        Collections.sort(linkedList, new IdentityComparator());
        return Collections.unmodifiableCollection(linkedList);
    }

    private Collection getAllPluginFragments() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.registry.getPluginFragments());
        Collections.sort(linkedList, new IdentityComparator());
        return Collections.unmodifiableCollection(linkedList);
    }

    private Collection getAllExtensionPoints() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.registry.getPluginDescriptors().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((PluginDescriptor)iterator.next()).getExtensionPoints());
        }
        Collections.sort(linkedList, new IdentityComparator());
        return Collections.unmodifiableCollection(linkedList);
    }

    private Collection getAllExtensions() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.registry.getPluginDescriptors().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((PluginDescriptor)iterator.next()).getExtensions());
        }
        Collections.sort(linkedList, new IdentityComparator());
        return Collections.unmodifiableCollection(linkedList);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class IdentityComparator
    implements Comparator {
        private IdentityComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Identity)object).getId().compareTo(((Identity)object2).getId());
        }
    }

    public static final class Tool {
        private String relativePath;

        protected Tool(String string) {
            this.relativePath = string;
        }

        public String getLink(Documentation.Reference reference) {
            PluginElement pluginElement;
            PluginFragment pluginFragment;
            if (this.isAbsoluteUrl(reference.getRef())) {
                return reference.getRef();
            }
            Identity identity = reference.getDeclaringIdentity();
            String string = identity instanceof PluginElement ? ((pluginFragment = (pluginElement = (PluginElement)identity).getDeclaringPluginFragment()) != null ? pluginFragment.getId() : pluginElement.getDeclaringPluginDescriptor().getId()) : identity.getId();
            return this.relativePath + "/" + string + "/extra/" + reference.getRef();
        }

        public boolean isAbsoluteUrl(String string) {
            try {
                String string2 = new URL(string).getProtocol();
                return string2 != null && string2.length() > 0;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }

        public String processDocText(String string) {
            if (string == null || string.length() == 0) {
                return "";
            }
            return string.replaceAll("(?d)(?m)\\$\\{relativePath\\}", this.relativePath);
        }
    }
}

