/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001-2002 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <assert.h>
#include "Translator.h"

	Translator::Translator(void){
		language = (char*)malloc( CHAR_2 );
		sprintf(language,"En");	
		trad = new map<int,char*>;
		load_ressource_file();
	}

	Translator::Translator(const char* language){
		this->language = (char*)malloc( CHAR_2 );
		sprintf(this->language,"%s",language);			
		trad = new map<int,char*>;
		load_ressource_file();
	}

	Translator::~Translator(void){
		delete trad;
		free(this->language);
	}

	void Translator::set_language(const char* language){
		this->language = (char*)malloc( CHAR_2 );
		sprintf(this->language,"%s",language);
		load_ressource_file();
	}

	char* Translator::get_language(void){
		return language;
	}

	const char* Translator::get_text_by_ID(int id){
		return ((((*trad)[id])!=NULL)?((*trad)[id]):(""));
	}

	char* Translator::strLeft(const char * str,int n){
		char* tmp;
		assert(n > 0 && n < (int)strlen(str));
		/* It'd  consume less memory to strdup the truncated string
		* rather than truncating the strduped string..
		* but it'd take a couple more cycles.... */
  		tmp = strdup(str);
		tmp[n] = '\0';
  		return tmp;
	}

	char* Translator::strRight(const char * str, int n){
  		char * tmp;
        assert(n > 0 && n < (int)strlen(str));
		tmp = strdup(str + n);
  		return tmp;
	}	

	char* Translator::strTrim(const char * str){
		char * tmp; tmp = strdup(str);
		while (strcmp(strLeft(tmp,1)," ") == 0){
			tmp = strRight(tmp,strlen(tmp) - 1);
		}
		while (strcmp(strRight(tmp,1)," ") == 0){
			tmp = strLeft(tmp,strlen(tmp) - 1);
		}
		return tmp;        
	}

	int Translator::load_ressource_file(void){
		char filename[255];
		sprintf(filename,"%s/%s.dat",I18N_PATH,language);
		FILE* fd = fopen(filename,"r");
	
		if(!fd) {
			fprintf(stderr,"Unable to load ressource file %s\n", filename);
			return -1;
		}

		char buf[255];
		int id;
		unsigned int i;
		char *tmp;
		trad->clear();
		while (fgets(buf, 255, fd)){
			for(i=0;i<strlen(buf);i++){
				if(buf[i]==':') break;
			}

			if(i>=strlen(buf)) continue;

			tmp = strdup(buf);
			tmp[i] = '\0';
			id = atoi(tmp);
			buf[strlen(buf)-1] ='\0'; // pour virer le saut de ligne final

			trad->insert(std::make_pair(id,to_ascii(strTrim(strdup(buf+i+1)))));
		}

		fclose(fd);

		return 1;
	}

	char* Translator::to_ascii(char* str){
		unsigned int i=0;
		for(i=0;i<strlen(str);i++){
			if( (int)str[i] < 0 ){
				switch(str[i]){
					case '':
					case '':
					case '':
					case '':
						str[i] = 'e';
						break;
					case '':
					case '':
					case '':
						str[i] = 'a';
						break;
					case '':
					case '':
					case '':
						str[i] = 'i';
						break;
					case '':
					case '':
					case '':
						str[i] = 'o';
						break;
					case '':
					case '':
					case '':
						str[i] = 'u';
						break;
					case '':
						str[i] = 'c';
						break;
					
				default:
					str[i] = ' ';
					break;
				}
			}
		}
		return str;
	}
