//////////////////////////////////////////////////////////////////////
//
// MIME Character Classification
//
// Jeff Lee
// Dec 16, 2000
//
//////////////////////////////////////////////////////////////////////
//#include "StdAfx.h"
#include "../../../include/nntp/mime/MimeChar.h"

// TSPECIAL as defined in RFC 2045 appendix A
const unsigned char CMimeChar::m_aCharTbl[128] =
{
	CONTROL,						// 00 (NUL)
	CONTROL,						// 01 (SOH)
	CONTROL,						// 02 (STX)
	CONTROL,						// 03 (ETX)
	CONTROL,						// 04 (EOT)
	CONTROL,						// 05 (ENQ)
	CONTROL,						// 06 (ACK)
	CONTROL,						// 07 (BEL)
	CONTROL,						// 08 (BS)
	SPACE | CONTROL,				// 09 (HT)
	SPACE | CONTROL,				// 0A (LF)
	SPACE | CONTROL,				// 0B (VT)
	SPACE | CONTROL,				// 0C (FF)
	SPACE | CONTROL,				// 0D (CR)
	CONTROL,						// 0E (SI)
	CONTROL,						// 0F (SO)
	CONTROL,						// 10 (DLE)
	CONTROL,						// 11 (DC1)
	CONTROL,						// 12 (DC2)
	CONTROL,						// 13 (DC3)
	CONTROL,						// 14 (DC4)
	CONTROL,						// 15 (NAK)
	CONTROL,						// 16 (SYN)
	CONTROL,						// 17 (ETB)
	CONTROL,						// 18 (CAN)
	CONTROL,						// 19 (EM)
	CONTROL,						// 1A (SUB)
	CONTROL,						// 1B (ESC)
	CONTROL,						// 1C (FS)
	CONTROL,						// 1D (GS)
	CONTROL,						// 1E (RS)
	CONTROL,						// 1F (US)
	SPACE,							// 20 SPACE
	PUNCT,							// 21 !
	PUNCT | SPECIAL | TSPECIAL,		// 22 "
	PUNCT,							// 23 #
	PUNCT,							// 24 $
	PUNCT,							// 25 %
	PUNCT,							// 26 &
	PUNCT,							// 27 '
	PUNCT | SPECIAL | TSPECIAL,		// 28 (
	PUNCT | SPECIAL | TSPECIAL,		// 29 )
	PUNCT,							// 2A *
	PUNCT,							// 2B +
	PUNCT | SPECIAL | TSPECIAL,		// 2C ,
	PUNCT,							// 2D -
	PUNCT | SPECIAL,				// 2E .
	PUNCT | TSPECIAL,				// 2F /
	PRINT | HEXDIGIT,				// 30 0
	PRINT | HEXDIGIT,				// 31 1
	PRINT | HEXDIGIT,				// 32 2
	PRINT | HEXDIGIT,				// 33 3
	PRINT | HEXDIGIT,				// 34 4
	PRINT | HEXDIGIT,				// 35 5
	PRINT | HEXDIGIT,				// 36 6
	PRINT | HEXDIGIT,				// 37 7
	PRINT | HEXDIGIT,				// 38 8
	PRINT | HEXDIGIT,				// 39 9
	PUNCT | SPECIAL | TSPECIAL,		// 3A :
	PUNCT | SPECIAL | TSPECIAL,		// 3B ;
	PUNCT | SPECIAL | TSPECIAL,		// 3C <
	PUNCT | SPECIAL | TSPECIAL,		// 3D =
	PUNCT | SPECIAL | TSPECIAL,		// 3E >
	PUNCT | TSPECIAL,				// 3F ?
	PUNCT | SPECIAL | TSPECIAL,		// 40 @
	PRINT | HEXDIGIT,				// 41 A
	PRINT | HEXDIGIT,				// 42 B
	PRINT | HEXDIGIT,				// 43 C
	PRINT | HEXDIGIT,				// 44 D
	PRINT | HEXDIGIT,				// 45 E
	PRINT | HEXDIGIT,				// 46 F
	PRINT,							// 47 G
	PRINT,							// 48 H
	PRINT,							// 49 I
	PRINT,							// 4A J
	PRINT,							// 4B K
	PRINT,							// 4C L
	PRINT,							// 4D M
	PRINT,							// 4E N
	PRINT,							// 4F O
	PRINT,							// 50 P
	PRINT,							// 51 Q
	PRINT,							// 52 R
	PRINT,							// 53 S
	PRINT,							// 54 T
	PRINT,							// 55 U
	PRINT,							// 56 V
	PRINT,							// 57 W
	PRINT,							// 58 X
	PRINT,							// 59 Y
	PRINT,							// 5A Z
	PUNCT | SPECIAL | TSPECIAL,		// 5B [
	PUNCT | SPECIAL | TSPECIAL,		// 5C '\'
	PUNCT | SPECIAL | TSPECIAL,		// 5D ]
	PUNCT,							// 5E ^
	PUNCT,							// 5F 
	PUNCT,							// 60 `
	PRINT,							// 61 a
	PRINT,							// 62 b
	PRINT,							// 63 c
	PRINT,							// 64 d
	PRINT,							// 65 e
	PRINT,							// 66 f
	PRINT,							// 67 g
	PRINT,							// 68 h
	PRINT,							// 69 i
	PRINT,							// 6A j
	PRINT,							// 6B k
	PRINT,							// 6C l
	PRINT,							// 6D m
	PRINT,							// 6E n
	PRINT,							// 6F o
	PRINT,							// 70 p
	PRINT,							// 71 q
	PRINT,							// 72 r
	PRINT,							// 73 s
	PRINT,							// 74 t
	PRINT,							// 75 u
	PRINT,							// 76 v
	PRINT,							// 77 w
	PRINT,							// 78 x
	PRINT,							// 79 y
	PRINT,							// 7A z
	PUNCT,							// 7B {
	PUNCT,							// 7C |
	PUNCT,							// 7D }
	PUNCT,							// 7E ~
	CONTROL,						// 7F (DEL)
};
